<?php

header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
ini_set('error_reporting', E_ALL);
ini_set('display_errors', E_ALL);

use FwRoutingSystem\Router;
use model\ChatMessages;
use site\helpers\ZarinPalPayment;

include 'src/autoload.php';
define('__HOST__', trim(FwConfig::HOST()));
define('__IMAGES__', 'https://' . __HOST__ . '/src/images/');
define('__FILES__', 'https://' . __HOST__ . '/src/images/Files/');


$Router = new Router();


$Router->any('/callback', function () {
    $Authority = $_GET['Authority'];
    $Payment = new ZarinPalPayment();
    $Payment->initPayment(new \model\PaymentTable());
    [
        $paymentData,
        $paymentResult
    ] = $Payment->getResult($Authority);
    if ($paymentResult['data']['code'] !== 100) {
//        $Payment->update($_GET['Authority'], $_GET['Authority']);

        include __BASE_DIR__ . '/callback-fail.php';
    } else {
        $Payment->update($_GET['Authority'], $_GET['Authority']);
        include __BASE_DIR__ . '/callback-success.php';
    }
});
$Router->any('/uploadChatFile/:id', function ($chatId) {
    $chat = \model\Chats::get($chatId);
    if ($chat instanceof \model\Entity\ChatsEntity) {
        /** @var \model\Entity\UsersEntity $user */
        $user = \model\Users::get($chat->user_id);
        $key = md5(date("Y-m-d-H:i:s:u")) . '_' . $user->user_id;
        $image = $_FILES['file'];
        [
            $category,
            $type
        ] = explode('/', $image['type']);
        switch ($category) {
            case "image":
                $key = "image_$key";
                $path = __SOURCE__ . 'images/Chat/Image/';
                $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
                $imageFileName = $key . '.' . $ext;
                $thumbFileName = "thumb" . $key . '.' . $ext;
                if (move_uploaded_file($image['tmp_name'], $path . $imageFileName)) {
                    switch ($ext) {
                        case "png":
                            $img = imagecreatefrompng($path . $imageFileName);
                            imagepng($img, $path . $thumbFileName, 2, PNG_NO_FILTER);
                            imagedestroy($img);
                            break;
                        case "jpg":
                        case "jpeg":
                            $img = imagecreatefromjpeg($path . $imageFileName);
                            imagejpeg($img, $path . $thumbFileName, 75);
                            imagedestroy($img);
                            break;
                        case "webp":
                            $img = imagecreatefromwebp($path . $imageFileName);
                            imagewebp($img, $path . $thumbFileName, 75);
                            imagedestroy($img);
                            break;
                        default:
                            move_uploaded_file($image['tmp_name'], $path . $thumbFileName);
                    }
                }
                $content = json_encode([
                    'path'      => __IMAGES__ . 'Chat/Image/' . $imageFileName,
                    'name'      => $imageFileName,
                    'thumbnail' => __IMAGES__ . 'Chat/Image/' . $thumbFileName,
                ]);
                break;
            case "application":
                $key = "file_$key";

                $path = __SOURCE__ . 'images/Chat/File/';
                $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
                $fileName = $key . '.' . $ext;
                move_uploaded_file($image['tmp_name'], $path . $fileName);
                $content = json_encode([
                    'path' => __IMAGES__ . 'Chat/File/' . $fileName,
                    'name' => $image['name'],
                    'size' => getFormattedFileSize(filesize($path . $fileName), 1),
                    'type' => strtoupper($type),
                ]);
                break;
            case "audio":
                $key = "audio_$key";

                $path = __SOURCE__ . 'images/Chat/Audio/';
                $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
                $fileName = $key . '.' . $ext;
                move_uploaded_file($image['tmp_name'], $path . $fileName);
                $content = json_encode([
                    'path'     => __IMAGES__ . 'Chat/Audio/' . $fileName,
                    'name'     => $image['name'],
                    'size'     => getFormattedFileSize(filesize($path . $fileName), 1),
                    'duration' => '0',
                ]);
                break;
            default:
                $key = "file_$key";

                $path = __SOURCE__ . 'images/Chat/File/';
                $ext = pathinfo($image['name'], PATHINFO_EXTENSION);
                $fileName = $key . '.' . $ext;
                move_uploaded_file($image['tmp_name'], $path . $fileName);
                $content = json_encode([
                    'path' => __IMAGES__ . 'Chat/File/' . $fileName,
                    'name' => $image['name'],
                    'type' => $ext,
                    'size' => getFormattedFileSize(filesize($path . $fileName), 1),
                ]);
                break;
        }

        if ($messageId = ChatMessages::add([
            'message_content' => $content,
            'chat_id'         => $chatId,
            'sender'          => 'operator',
            'user_id'         => $user->user_id,
            'operator_id'     => $chat->operator_id,
            'message_type'    => str($key)->explode('_')[0],
        ])) {
            $message = ChatMessages::get($messageId);
            sendPushNotification($user->firebase_token, "اپراتور شماره {$chat->operator_id}", $message->apiFormat($user), $message->preview());
            return 'ok';
        }


    }
    return "آپلود با خطا مواجه شد";
});
$Router->get('/see', function () {
    $all = \model\UserTemps::getAll();
    foreach ($all as $item) {
        var_dump($item);
        echo "<br/>";
    }
});
$Router->__defaults();

