<?php

namespace FwAuthSystem\Role;

use controller\Categories;
use controller\Chats;
use controller\Contractors;
use controller\Individuals;
use controller\OperatorReports;
use controller\Orders;
use controller\Reminders;
use controller\Services;
use controller\Users;
use FwAuthSystem\Utils\AuthRole;
use model\UsersTable;

if (!class_exists('FwAuthSystem\Role\OperatorRole')) {
    class OperatorRole extends AuthRole
    {
        public static function accessList(): array
        {
            // list of available controllers for this role
            return [
                Users::class,
                Orders::class,
                Chats::class,
                Reminders::class,
                Individuals::class,
                OperatorReports::class
            ];
        }


        public static function roleName(): string
        {
            // role main names
            return 'اپراتور';
        }
    }
}