<?php

namespace FwAuthSystem\Role;

use controller\Announcements;
use controller\Categories;
use controller\Chats;
use controller\Orders;
use controller\PreparedMessages;
use controller\SearchTags;
use controller\Services;
use controller\TopSliders;
use controller\Users;
use controller\UsersTable;
use FwAuthSystem\Utils\AuthRole;

if (!class_exists('FwAuthSystem\Role\SupervisorRole')) {
    class SupervisorRole extends AuthRole
    {
        public static function accessList(): array
        {
            // list of available controllers for this role
            return [
                Categories::class,
                Services::class,
                PreparedMessages::class,
                UsersTable::class,
                Chats::class,
                Orders::class,
                TopSliders::class,
                Announcements::class,
                SearchTags::class
            ];
        }

        public static function roleName(): string
        {
            // role main names
            return 'سوپروایزر';
        }
    }
}