<?php

namespace controller;

use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\CitiesEntity;
use model\Entity\StatesEntity;

class Cities extends ControllerScheme
{
    const name = 'شهر';

    public function inState()
    {
        $stateId = $this->requestArray('state_id');
        return collect([
            HtmlTags::Option()->Disabled()->Selected()->Value('0')->Content("لطفا یک مورد را انتخاب کنید"),
        ])->merge(\model\Cities::getAllFiltered('state_id', $stateId)->map(function (CitiesEntity  $state) {
            return $state->toOption();
        }))->join('');
    }
}