<?php

namespace controller;

use ControllerScheme;
use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;
use FwAuthSystem\Main\UserObject;
use model\ChatMessages;
use model\Entity\ChatArchivesEntity;
use model\Entity\ChatMessagesEntity;
use model\Entity\ChatsEntity;
use model\Entity\ServicesEntity;
use model\Entity\UsersEntity;

class Chats extends ControllerScheme
{
    const name = 'چت';

    public function archivedChats()
    {
        return $this->view($this->viewName(), 'archivedChats', [

        ]);
    }

    public function sendMessage()
    {
        $message = $this->requestArray('message');
        $id = $this->requestArray('chatId');

        $chat = \model\Chats::get($id);
        if ($chat instanceof ChatsEntity) {
            $user = $chat->user();
            $operatorId = UserObject::instance()->getUserId();
            if ($id = \model\ChatMessages::add([
                'message_content' => json_encode([
                    'text' => $message,
                ], JSON_UNESCAPED_UNICODE),
                'message_type' => 'text',
                'message_read' => 0,
                'chat_id' => $chat->chat_id,
                'operator_id' => $operatorId,
                'user_id' => $user->user_id,
                'sender' => 'operator',
            ])) {
                /** @var ChatMessagesEntity $message */
                $message = \model\ChatMessages::get($id);
                sendPushNotification($user->firebase_token, "اپراتور شماره {$operatorId}", $message->apiFormat($user), $message->preview());
                return $this->fetchMessages();
            }
        }
        return $this->fetchMessages();
    }

    public function fetchMessages(): string
    {
        $id = $this->requestArray('chatId');
        $adminID = UserObject::instance()->getUserId();

        $messages = \model\ChatMessages::Db()->where("chat_id", $id)->orderBy('created_at')->get()->map(function (ChatMessagesEntity $chatMessagesEntity) use ($adminID) {
            return $chatMessagesEntity->buildMessage($adminID);
        });
        $messageIds = \model\ChatMessages::Db()->where("chat_id", $id)->orderBy('created_at')->get()->map(function (ChatMessagesEntity $chatMessagesEntity) {
            return $chatMessagesEntity->chat_message_id;
        });

        $messageIds = ChatMessages::Db()->whereIn('chat_message_id', $messageIds->map(function ($message) {
            return $message;
        })->values()->all())->where('sender', 'user')->update([
            'message_read' => 1,
        ]);
        /** @var ChatsEntity $chat */
        $chat = \model\Chats::get($id);
        /** @var ServicesEntity $order */
        $order = \model\Orders::get($chat->order_id);
        $service = \model\Services::get($order->service_id);
        $instance = UserObject::instance();
        /** @var UsersEntity $user */
        $user = \model\Users::get($order->user_id);
        return json_encode([
            'service' => $service->service_name,
            'user' => $user->firstname . ' ' . $user->lastname,
            'content' => $messages->join(''),
            'count' => $messages->length(),
            'isClosed' => $chat->chat_status == 2,
            'orderId' => $chat->order_id,
            'hasAccess' => $instance instanceof UserObject && $chat->operator_id == $instance->getUserId(),
        ]);
    }

    public function fetchArchive(): string
    {
        $id = $this->requestArray('chatId');
        $adminID = UserObject::instance()->getUserId();

        $messages = \model\ChatMessages::Db()->where("chat_id", $id)->orderBy('created_at')->get()->map(function (ChatMessagesEntity $chatMessagesEntity) use ($adminID) {
            return $chatMessagesEntity->buildMessage($adminID);
        });
        /** @var \model\Entity\ChatArchivesEntity $chat */
        $chat = \model\ChatArchives::getOneFiltered("chat_id", $id);
        $instance = UserObject::instance();
        return json_encode([
            'content' => $messages->join(''),
            'count' => $messages->length(),
            'isClosed' => $chat->chat_status == 2,
            'orderId' => $chat->order_id,
            'hasAccess' => $instance instanceof UserObject && $chat->operator_id == $instance->getUserId(),
        ]);
    }

    public function sendFactor()
    {
        $id = $this->requestArray('chatId');
        $rows = $this->requestArray();
        unset($rows['chatId']);
        unset($rows['controller_type']);
        $content = [
            'items' => [],
        ];
        $total = 0;
        $totalDiscount = 0;
        foreach ($rows['name'] as $index => $name) {
            $price = (int)(str($rows['price'][$index])->replace(',', '')->getValue());
            $discount = (int)$rows['discount'][$index];
            $total += $price;
            $totalDiscount += (int)($price * $discount / 100);
            $content['items'][] = [
                'index' => (int)$index,
                'name' => $name,
                'price' => $price,
                'discount' => $discount,
            ];
        }
        $content['total'] = (int)$total;
        $content['totalDiscountPercent'] = $totalDiscount * 100 / $total;
        $content['totalDiscount'] = $totalDiscount;
        $content['previousPayment'] = 0;
        $content['duePayment'] = $total - $totalDiscount;
        $content['items'] = json_encode($content['items'], JSON_UNESCAPED_UNICODE);
        $content['isPayed'] = 1;
        $content['status'] = 0;
        $chat = \model\Chats::get($id);
        if ($chat instanceof ChatsEntity) {
            $content['chat_id'] = $chat->chat_id;
            $content['order_id'] = $chat->order_id;
            $id = Db::table('tblInvoices')->insertWithId($content);
            $content['isPayed'] = true;
            $content['items'] = json_decode($content['items']);
            $content['id'] = base64_encode($id);
            unset($content['chat_id']);
            unset($content['order_id']);
            $user = $chat->user();
            $operatorId = UserObject::instance()->getUserId();
            if ($id = \model\ChatMessages::add([
                'message_content' => json_encode($content, JSON_UNESCAPED_UNICODE),
                'message_type' => 'pay',
                'message_read' => 0,
                'chat_id' => $chat->chat_id,
                'operator_id' => $operatorId,
                'user_id' => $user->user_id,
                'sender' => 'operator',
            ])) {

                /** @var ChatMessagesEntity $message */
                $message = \model\ChatMessages::get($id);
                sendPushNotification($user->firebase_token, "اپراتور شماره {$operatorId}", $message->apiFormat($user), $message->preview());
                return $this->fetchMessages();
            }
        }
        return $this->fetchMessages();
    }

    public function closeChat()
    {
        $chatId = $this->requestArray('chatId');
        if (\model\Chats::edit($chatId, [
            'chat_status' => 2,
        ])) {
            /** @var UsersEntity $user */
            /** @var ChatsEntity $chat */
            $chat = \model\Chats::get($chatId);
            $user = \model\Users::get($chat->user_id);
            sendPushNotification($user->firebase_token, 'چت بسته شد!', [
                'chatId' => $chatId,
                'type' => 'closeChat',
            ], "چت مربوط به پرونده شماره $chat->order_id بسته شد.");
            return 'done';
        }
        return 'false';
    }

    public function openChat()
    {
        $chatId = $this->requestArray('chatId');
        if (\model\Chats::edit($chatId, [
            'chat_status' => 1,
        ])) {
            /** @var UsersEntity $user */
            /** @var ChatsEntity $chat */
            $chat = \model\Chats::get($chatId);
            $user = \model\Users::get($chat->user_id);
            sendPushNotification($user->firebase_token, 'چت باز شد!', [
                'chatId' => $chatId,
                'type' => 'openChat',
            ], "چت مربوط به پرونده شماره $chat->order_id باز شد.");
            return 'done';
        }
        return 'false';
    }

    public function archiveChat()
    {
        $chatId = $this->requestArray('chatId');
        $chat = \model\Chats::get($chatId);
        if ($chat instanceof ChatsEntity) {
            if (\model\Chats::edit($chatId, [
                'chat_status' => 2,
            ])) {
                /** @var UsersEntity $user */
                /** @var ChatsEntity $chat */
                $chat = \model\Chats::get($chatId);
                $user = \model\Users::get($chat->user_id);
                sendPushNotification($user->firebase_token, 'چت بسته شد!', [
                    'chatId' => $chatId,
                    'type' => 'closeChat',
                ], "چت مربوط به پرونده شماره $chat->order_id بسته شد.");
                /** @var UsersEntity $user */
                $user = \model\Users::get($chat->user_id);
                return 'done';
            }
        }
        return 'false';
    }

    public function closeOrder()
    {
        $chatId = $this->requestArray('chatId');
        $chat = \model\Chats::get($chatId);
        if ($chat instanceof ChatsEntity) {
            if (\model\ChatArchives::add([
                'user_id' => $chat->user_id,
                'chat_id' => $chatId,
                'operator_id' => $chat->operator_id,
                'order_id' => $chat->order_id,
                'chat_status' => $chat->chat_status,
                'created_at' => $chat->created_at,
            ])) {
                $edit = \model\Orders::edit($chat->order_id, [
                    'order_status' => 1,
                ]);
                \model\Chats::delete($chatId);
                /** @var UsersEntity $user */
                $user = \model\Users::get($chat->user_id);
                return 'done';
            }
        }
        return 'false';
    }

    public function unArchiveChat()
    {
        $chatId = $this->requestArray('chatId');
        $chat = \model\ChatArchives::getOneFiltered('chat_id', $chatId);
        if ($chat instanceof ChatArchivesEntity) {
            if (\model\Chats::add([
                'user_id' => $chat->user_id,
                'chat_id' => $chatId,
                'operator_id' => $chat->operator_id,
                'order_id' => $chat->order_id,
                'chat_status' => $chat->chat_status,
                'created_at' => $chat->created_at,
            ])) {
                \model\ChatArchives::delete($chat->chat_archive_id);
                /** @var UsersEntity $user */
                $user = \model\Users::get($chat->user_id);
                return 'done';
            }
        }
        return 'false';
    }

    public function fetchChatNewFactor()
    {
        $id = $this->requestArray('chatId');
        /** @var ChatsEntity $chat */
        $chat = \model\Chats::get($id);
        /** @var \model\Entity\OrdersEntity $order */
        $order = \model\Orders::get($chat->order_id);
        $service = \model\Services::get($order->service_id);
        header("Content-type: application/json");
        return json_encode([
            'price' => $service->service_price,
            'discount' => $service->service_price * 0.09,
        ]);
    }

}