<?php
namespace controller;
use ControllerScheme;
class Individuals extends ControllerScheme {
    const name = 'اطلاعات تکمیلی کاربر';

    protected function add(?bool $csrf = true)
    {
        $user_id =$this->requestArray()['user_id'];
        $nationalCode =$this->requestArray()['individual_national_code'];
        $telephone = str_replace('(','',str_replace(')','',str_replace(" ",'',$this->requestArray()['individual_telephone'])));
        $birthdate =  persianStrToTime($this->requestArray()['individual_birthdate']);
        $creditCard = str_replace(' ','',$this->requestArray()['individual_credit_card_number']);
        $sheba = "IR".str_replace(' ','',$this->requestArray()['individual_sheba_number']);
        $hasCar = $this->requestArray()['individual_has_car_yes_no'];
        $carPlate =[en_to_fa($this->requestArray()['individual_plate_one']),$this->requestArray()['individual_plate_char'],en_to_fa($this->requestArray()['individual_plate_two']),"ایران".en_to_fa($this->requestArray()['individual_plate_city_code'])];
        $licenseType = $this->requestArray()['individual_license_type'];
        $hasChild = $this->requestArray()['individual_has_child_yes_no'];
        $childrenCount = $this->requestArray()['individual_children_count'];
        $birthdays = $this->requestArray()['birthdates'];
        $timeStampBirthdays=[];
        foreach ($birthdays as $item){
            $timeStampBirthdays[]=persianStrToTime($item);
        }

        $add = $this->model()::add([
           'user_id'=> $user_id,
            "individual_national_code"=>$nationalCode,
            "individual_credit_card_number"=>$creditCard,
            "individual_sheba_number"=>$sheba,
            "individual_telephone"=>$telephone,
            "individual_birthdate"=>$birthdate,
            "individual_has_car_yes_no"=>$hasCar,
            "individual_plate_number"=>json_encode($carPlate,JSON_UNESCAPED_UNICODE),
            "individual_license_type"=>$licenseType,
            "individual_has_child_yes_no"=>$hasChild,
            "individual_children_count"=>$childrenCount,
            "individual_children_birthdates"=>json_encode($timeStampBirthdays,JSON_UNESCAPED_UNICODE),
        ]);

        if ($add){
            return showSuccessMsg(self::name,'افزودن');
        }else{
            return showErrorMsg(self::name,'افزودن');
        }
    }

    public function edit()
    {
        $individual_id = $this->requestArray()['individual_id'];
        $user_id =$this->requestArray()['user_id'];
        $nationalCode =$this->requestArray()['individual_national_code'];
        $telephone = str_replace('(','',str_replace(')','',str_replace(" ",'',$this->requestArray()['individual_telephone'])));
        $birthdate =  persianStrToTime($this->requestArray()['individual_birthdate']);
        $creditCard = str_replace(' ','',$this->requestArray()['individual_credit_card_number']);
        $sheba = "IR".str_replace(' ','',$this->requestArray()['individual_sheba_number']);
        $hasCar = $this->requestArray()['individual_has_car_yes_no'];
        $carPlate =[en_to_fa($this->requestArray()['individual_plate_one']),$this->requestArray()['individual_plate_char'],en_to_fa($this->requestArray()['individual_plate_two']),"ایران".en_to_fa($this->requestArray()['individual_plate_city_code'])];
        $licenseType = $this->requestArray()['individual_license_type'];
        $hasChild = $this->requestArray()['individual_has_child_yes_no'];
        $childrenCount = $this->requestArray()['individual_children_count'];
        $birthdays = $this->requestArray()['birthdates'];
        $timeStampBirthdays=[];
        foreach ($birthdays as $item){
            $timeStampBirthdays[]=persianStrToTime($item);
        }

        $add = $this->model()::edit($individual_id,[
            'user_id'=> $user_id,
            "individual_national_code"=>$nationalCode,
            "individual_credit_card_number"=>$creditCard,
            "individual_sheba_number"=>$sheba,
            "individual_telephone"=>$telephone,
            "individual_birthdate"=>$birthdate,
            "individual_has_car_yes_no"=>$hasCar,
            "individual_plate_number"=>json_encode($carPlate,JSON_UNESCAPED_UNICODE),
            "individual_license_type"=>$licenseType,
            "individual_has_child_yes_no"=>$hasChild,
            "individual_children_count"=>$childrenCount,
            "individual_children_birthdates"=>json_encode($timeStampBirthdays,JSON_UNESCAPED_UNICODE),
        ]);

        if ($add){
            return showSuccessMsg(self::name,'ویرایش');
        }else{
            return showErrorMsg(self::name,'ویرایش');
        }
    }

}