<?php

namespace controller;

use ControllerScheme;
use FwAuthSystem\Main\UserObject;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\ChatMessages;
use model\Chats;

class Orders extends ControllerScheme {
    const name = 'سفارش';

    public function main(): string {
        $data = $_GET;
        $query = $this->model()::Db();
        if (is_array($data) and !empty($data)) {
            $query->where($data);
        }
        return $this->view($this->viewName(), 'main', [
            $query->get(),
        ]);
    }

    public function noOperatorOrders(): string {
        $query = $this->model()::Db()->where('user_table_id', '0');
        return $this->view($this->viewName(), 'main', [
            $query->get(),
        ]);
    }

    public function supervisorMain(): string {
        $data = $_GET;
        $supervisorId = UserObject::instance()->getUserId();
        $operators = \model\UsersTable::getAllFiltered('supervisor_id', $supervisorId);
        $user_table_ids = [$supervisorId];
        foreach ($operators as $operator) {
            $user_table_ids[] = $operator->user_id;
        }

        $query = $this->model()::Db()->whereIn("user_table_id", $user_table_ids);
        if (is_array($data) and !empty($data)) {
            $query->where($data);
        }
        return $this->view($this->viewName(), 'main', [
            $query->get(),
        ]);
    }

    public function getServices() {
        $cat = $this->requestArray()['category_id'];
        $output = [HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد راانتخاب کنید')];
        foreach (\model\Services::getAllFiltered('category_id', $cat) as $item) {
            $output[] = HtmlTags::Option()->Value($item->service_id)->Content($item->service_name);
        }
        return implode('', $output);
    }

    public function getServicePrice() {
        $id = $this->requestArray()['id'];
        return \model\Services::get($id)->service_price;
    }

    public function getServiceForm() {
        $id = $this->requestArray()['id'];
        $serviceForm = \model\Services::get($id)->service_form;
        if ($serviceForm == "{}") {
            return "سرویس انتخاب شده فاقد فرم میباشد";
        } else {
            $decode = json_decode($serviceForm);
            $output = [];
            foreach ($decode as $key => $item) {
                $view = new \view\Orders($this);
                $input = HtmlTags::Div();
                if ($item->type == 'input') {
                    switch ($item->validation) {
                        case 'Mobile':
                            $input = $view->Html()->Mobile($key, $key, '', $item->required == true, false, 'form-control', $item->placeholder ?? "");
                            break;
                        case 'Price':
                            $input = $view->Html()->Price($key, $key, 'تومان', '', $item->required == true, false, 'form-control', false, $input->placaholder ?? "");
                            break;
                        case 'Tel':
                            $input = $view->Html()->Tel($key, $key, '', $item->required == true, false, 'form-control', $item->placeholder ?? "");
                            break;
                        case 'Number':
                            $input = $view->Html()->Number($key, $key, '', $item->required == true, false, 'form-control', 'text', 'placeholder="' . $item->placeholder . '"');
                            break;
                        case 'English':
                            $input = $view->Html()->English($key, $key, '', $item->required == true, false, 'form-control', 'text', 'placeholder="' . $item->placeholder . '"');
                            break;
                        case 'Email':
                            $input = $view->Html()->Email($key, $key, '', $item->required == true, false, 'form-control', $item->placeholder ?? "");
                            break;
                        case 'Date':
                            $input = $view->Html()->Input($key)->Required($item->required == true)->PlaceHolder($item->placeholder ?? "")."<script>$('#$key').persianDatepicker()</script>";
                            break;
                        case 'input':
                        default:
                            $input = $view->Html()->Input($key)->Required($item->required == true)->PlaceHolder($item->placeholder ?? "");
                            break;
                    }
                } elseif ($item->type == 'select') {
                    $input = $view->Html()->Select($key, $key, collect($item->options)->map(function ($item) {
                        return HtmlTags::Option()->Value($item)->Content($item);
                    })->join(''));
                } elseif ($item->type == 'image') {
                    $width = $item->imageData->width;
                    $height = $item->imageData->height;
                    $input = $view->Html()->ImageInput($key, $item->imageData->type, $width, $height);
                }
                $output[] = HtmlTags::Div(".form-group.col-md-" . $item->col_md_)->Content(
                    HtmlTags::Label()->Content($item->label),
                    $input,
                );
            }
            return implode('', $output);
        }
    }

    public function changeOrderStatus() {
        $id = $this->requestArray()['id'];
        $status = $this->requestArray()['status'];
        if ($status === "paymentConfirm") {
            $finalStatus = 3;
        } else {
            $finalStatus = 1;
        }
        $edit = \model\Orders::edit($id, [
            'order_status' => $finalStatus
        ]);
        if ($edit) {
            return $status;
        } else {
            return "false";
        }
    }

    public function declineOrder()
    {

        $order = $this->requestArray()['orderId'];
        $userId = $this->requestArray()['userId'];
        $fToken = \model\Users::get($userId)->firebase_token;
        $text = "کاربر گرامی درخواست شما به دلیل نامعتبر بودن اطلاعات رد گردید. لطفا درخواستتان را با اطلاعات واقعی ثبت کنید";

        $edit = \model\Orders::edit($order,[
           'order_status' => 5
        ]);


        if ($edit){
            $notif = sendPushNotification($fToken, "پیام جدید", [
                'user_id'     => $userId,
                'type'       => 'declineOrder',
                'text' => $text,
            ], $text);

            if ($notif){
                return "1";
            }else{
                return "2";
            }

        }else{
            return "3";
        }



    }

    public function changeOperator() {
        $id = $this->requestArray('orderId');
        $operatorId = $this->requestArray('operatorId');
        /** @var \model\Entity\OrdersEntity $order */
        $order = \model\Orders::get($id);
        $edit = \model\Orders::edit($id, [
            'user_table_id' => $operatorId
        ]);
        $user = \model\Users::get($order->user_id);
        if ($order->user_table_id == 0) {
            sendPushNotification($user->firebase_token, "اپراتور یافت شد!", [
                'chatId'     => Chats::getOneFiltered('order_id', $order->order_id)->chat_id,
                'type'       => 'changeOperator',
                'operatorId' => $operatorId,
                'operator'   => \model\UsersTable::get($operatorId)->apiFormat(),
            ], "اپراتور شماره $operatorId برای سفارش شما برخط می باشد.");
        } else {
            sendPushNotification($user->firebase_token, "اپراتور تغییر یافت!", [
                'chatId'     => Chats::getOneFiltered('order_id', $order->order_id)->chat_id,
                'type'       => 'changeOperator',
                'operator'   => \model\UsersTable::get($operatorId)->apiFormat(),

                'operatorId' => $operatorId,
            ], "اپراتور شماره $operatorId برای سفارش شما برخط می باشد.");
        }
        if ($edit) {
            return "ok";
        } else {
            return "false";
        }
    }

    protected function add(?bool $csrf = true) {
        $user_table_id = UserObject::instance()->getUserId();
        $data = $this->requestArray();
        $user_id = $data['user_id'];
        unset($data['user_id']);
        $category_id = $data['category_id'];
        unset($data['category_id']);
        $service_id = $data['service_id'];
        unset($data['service_id']);
        $order_price = $data['order_price'];
        unset($data['order_price']);
        $order_status = $data['order_status'];
        unset($data['order_status']);
        unset($data['validations']);
        $form = jsonEncode($data, JSON_UNESCAPED_UNICODE);
        $add = $this->model()::add([
            'user_id'       => $user_id,
            'category_id'   => $category_id,
            'service_id'    => $service_id,
            'service_form'  => $form,
            'order_date'    => strtotime('today'),
            'order_price'   => $order_price,
            'order_from'    => '2',
            'user_table_id' => $user_table_id,
            'order_status'  => $order_status
        ]);
        if ($add) {
            if ($chatId = Chats::add([
                'user_id'     => $user_id,
                'operator_id' => $user_table_id,
                'order_id'    => $add,
            ])) {
                $service = \model\Services::get($service_id);
                if ($messageId = ChatMessages::add([
                    'message_content' => json_encode([
                        'text' => $service->service_startup_message,
                    ], JSON_UNESCAPED_UNICODE),
                    'message_type'    => 'text',
                    'message_read'    => 0,
                    'chat_id'         => $chatId,
                    'operator_id'     => $user_table_id,
                    'user_id'         => $user_id,
                    'sender'          => 'operator',
                ])) {
                    $user = \model\Users::get($user_id);
                    $message = ChatMessages::get($messageId);
                    sendPushNotification($user->firebase_token, "سفارش ثبت شد!", $message->pushFormat(),);
                }
            }
            return showSuccessMsg(self::name, 'افزودن');
        } else {
            return showErrorMsg(self::name, 'افزودن');
        }
    }

}