<?php

namespace controller;

use DATABASE\Model;
use FwBase\Reports\ReportScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;

class OperatorReports extends ReportScheme {
    public function getReport() {
        ob_start();
        $start_date = $this->isSet('date_from', function ($date_from) {
            if ($date_from == null) {
                return null;
            }
            return persianStrToTime($date_from);
        });
        $end_date = $this->isSet('date_to', function ($date_to) {
            if ($date_to == null) {
                return null;
            }
            return persianStrToTime($date_to);
        });
        $user_table_id = $this->isSet('user_table_id', function ($user_table_id) {
            if (is_numeric($user_table_id) and $user_table_id > 0) {
                return $user_table_id;
            }
            return null;
        });
        $status = $this->isSet('status', function ($status) {
            if (is_numeric($status) and $status > 0) {
                return $status;
            }
            return null;
        });
        $db = \model\Orders::Db()->where('order_id', '>', '0');
        if ($start_date) {
            $db->where('order_date', '>=', $start_date);
        }
        if ($end_date) {
            $db->where('order_date', '<=', $end_date);
        }
        if ($user_table_id) {
            $db->where('user_table_id', '=', $user_table_id);
        }
        if ($status) {
            $db->where('order_status', '=', $status);
        }
        $res = $db->get()->values()->all();
        $rows = [];
        $DeliveryReportView = new \view\OperatorReports($this);
        $i = 0;
        foreach ($res as $order) {
            $rows[] = $DeliveryReportView->toRow($order, $i);
            $res[] = $order;
        }


        $html = HtmlTags::Div('.card-body.d-flex.flex-wrap')->Content(

            $this->addCard($user_table_id
                ?
                \model\Orders::Db()->where('user_table_id', $order->user_table_id)->rowCount()
                : \model\Orders::Db()->rowCount(), 'تعداد سفارشات'),


            $this->addCard($user_table_id
                ?
                \model\Orders::Db()->where([
                    'user_table_id' => $order->user_table_id,
                    'order_status'  => 1,
                ])->rowCount()
                : \model\Orders::Db()->where([
                    'order_status' => 1,
                ])->rowCount(), 'سفارشات انجام شده'),


            $this->addCard($user_table_id
                ?
                \model\Orders::Db()->where([
                    'user_table_id' => $order->user_table_id,
                    'order_status'  => 2,
                ])->rowCount()
                : \model\Orders::Db()->where([
                    'order_status' => 2,
                ])->rowCount(), 'سفارشات در انتظار پرداخت'),


            $this->addCard($user_table_id
                ?
                \model\Orders::Db()->where([
                    'user_table_id' => $order->user_table_id,
                    'order_status'  => 3,
                ])->rowCount()
                : \model\Orders::Db()->where([
                    'order_status' => 3,
                ])->rowCount(), 'سفارشات در حال انجام'),


            $this->addCard($user_table_id
                ?
                \model\Orders::Db()->where([
                    'user_table_id' => $order->user_table_id,
                    'order_status'  => 0,
                ])->rowCount()
                : \model\Orders::Db()->where([
                    'order_status' => 0,
                ])->rowCount(), 'سفارشات در انتظار تایید','danger'),


            $this->addCard($user_table_id
                ?
                \model\Orders::Db()->where([
                    'user_table_id' => $order->user_table_id,
                    'order_status'  => 4,
                ])->rowCount()
                : \model\Orders::Db()->where([
                    'order_status' => 4,
                ])->rowCount(), 'سفارشات منقضی شده','danger'),


            $this->addCard($user_table_id
                ?
                \model\Orders::Db()->where([
                    'user_table_id' => $order->user_table_id,
                    'order_status'  => 5,
                ])->rowCount()
                : \model\Orders::Db()->where([
                    'order_status' => 5,
                ])->rowCount(), 'سفارشات تاییده نشده','danger'),


            $this->addCard($user_table_id
                ?
                \model\Orders::Db()->where([
                    'user_table_id' => $order->user_table_id,
                    'order_from'  => 1,
                ])->rowCount()
                : \model\Orders::Db()->where([
                    'order_from' => 1,
                ])->rowCount(), 'سفارشات اپلیکیشن','danger'),

            HtmlTags::Table('.table.table-bordered')->Content(
                HtmlTags::Thead('.table-dark')->Content(
                    $DeliveryReportView->thList()
                ),
                HtmlTags::Tbody()->Content(
                    implode('', $rows)
                )
            )
        );
        if (sizeof($res) === 0) {
            $html = HtmlTags::Div('.text-center.m-5')->Content(
                "نتیجه ای یافت نشد"
            );
        }
        echo json_encode([
            'status' => true,
            'html'   => $html
        ]);
    }

    private function addCard(string $showNumber, string $nameFiled, string $color = "success", string $link = "", string $id = ""): \FwHtml\Elements\Tags\Div {
        return HtmlTags::Div('.col-md-3')->Content(
            HtmlTags::Div(".small-box.card.card-$color.card-outline")->Content(
                HtmlTags::Div('.inner.text-center')->Content(
                    HtmlTags::H3($showNumber),
                    HtmlTags::P($nameFiled)
                ),
            )
        );
    }

    protected function setModel(Model $model = null): void {
        $this->model = new \model\Orders();
        $this->setKey($this->model->_key);
    }
}
