<?php

namespace controller;

use DATABASE\Model;
use FwBase\Reports\ReportScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;

class SaleReports extends ReportScheme {
    public function getReport() {
        ob_start();
        $start_date = $this->isSet('date_from', function ($date_from) {
            if ($date_from == null) {
                return null;
            }
            return persianStrToTime($date_from);
        });
        $end_date = $this->isSet('date_to', function ($date_to) {
            if ($date_to == null) {
                return null;
            }
            return persianStrToTime($date_to);
        });
        $status = $this->isSet('status', function ($status) {
            if (is_numeric($status) and $status > 0) {
                return $status;
            }
            return null;
        });
        $user_id = $this->isSet('user_id', function ($user_id) {
            if (is_numeric($user_id) and $user_id > 0) {
                return $user_id;
            }
            return null;
        });
        $db = \model\PaymentTable::Db()->where('payment_id', '>', '0');
        if ($start_date) {
            $db->where('payment_date', '>=', $start_date);
        }
        if ($end_date) {
            $db->where('payment_date', '<=', $end_date);
        }
        if ($status) {
            $db->where('payment_status', '=', $status);
        }
        if ($user_id) {
            $db->where('user_id', '=', $user_id);
        }
        $res = $db->get()->values()->all();
        $rows = [];
        $DeliveryReportView = new \view\SaleReports($this);
        $i = 0;
        foreach ($res as $order) {
            $rows[] = $DeliveryReportView->toRow($order, $i);
            $res[] = $order;
        }
        $html = HtmlTags::Div('.card-body')->Attrs(['style' => 'overflow-x: scroll'])->Content(
            HtmlTags::Table('.table.table-bordered')->Content(
                HtmlTags::Thead('.table-dark')->Content(
                    $DeliveryReportView->thList()
                ),
                HtmlTags::Tbody()->Content(
                    implode('', $rows)
                )
            )
        );
        if (sizeof($res) === 0) {
            $html = HtmlTags::Div('.text-center.m-5')->Content(
                "نتیجه ای یافت نشد"
            );
        }
        echo json_encode([
            'status' => true,
            'html'   => $html
        ]);
    }

    protected function setModel(Model $model = null): void {
        $this->model = new \model\PaymentTable();
        $this->setKey($this->model->_key);
    }


}
