<?php

namespace controller;

use ControllerScheme;

class SearchTags extends ControllerScheme
{
    const name = 'تگ های جستجو';

    protected function add(?bool $csrf = true)
    {
        $data = $this->requestArray();

        $searchTags = jsonEncode(array_filter(explode('*',str_replace(' ','',$data['search_tags']))),JSON_UNESCAPED_UNICODE);
        $add = $this->model()::add([
            'service_id' => $data['service_id'],
            'search_tag_correct' => $data['search_tag_correct'],
            "search_tags" => $searchTags
        ]);

        if ($add){
            return showSuccessMsg(self::name , 'افزودن');
        }else{
            return showErrorMsg(self::name,'افزودن');
        }
    }

}