<?php

namespace controller;

use Ammont\Finglify\Finglify;
use ControllerScheme;

class Services extends ControllerScheme {
    use \SortRowsController;

    const name = 'خدمات';
    protected static $__uploads = [
        "service_icon" => __SOURCE__ . 'images/Services/',
        "service_video" => __SOURCE__ . 'images/Services/',
    ];

    public function formGenerator() {
        $id = $this->requestArray('service_id');
        if ($id > 0) {
            $service = \model\Services::get($id);
            return $this->view($this->viewName(), 'formGenerator', [
                $service,
            ]);
        } else {
            return '404';
        }
    }

    public function saveForm() {
        $requests = $this->requestArray();
        $Items = [];
        $Names = [];
        $Labels = $requests['label'];
        $Col_types = $requests['col_type'];
        $Sliders = $requests['slider'];
        $Finglify = new Finglify();
        foreach ($Labels as $index => $label) {
            $name = $Finglify->translate($Labels[$index]);
            $name = str_replace(' ', '_', $name);
            $Names[$index] = $name;
            $Items[$name] = array(
                'label'       => $label,
                'order'       => str_replace('item_', '', $index),
                'type'        => $Col_types[$index],
                'validation'  => $requests['validations'][$index],
                'col_md_'     => $Sliders[$index],
                'imageData'   => $requests['imageData'][$index] ?? null,
                'options'     => $requests['options'][$index] ?? null,
                'placeholder' => $requests['placeholder'][$index] ?? null,
                'errorText'   => $requests['errorText'][$index] ?? null,
                'hint'        => $requests['hint'][$index] ?? null,
                'required'    => $requests['required'][$index] == '1',
            );
        }
        $Items = json_encode($Items, JSON_UNESCAPED_UNICODE);
        return showResult(\model\Services::edit($this->requestArray('service_id'), [
            'service_form' => $Items,
        ]), 'فرم', 'ویرایش');
    }

    public function changeStatus() {
        $status = $this->requestArray()['status'];
        $id = $this->requestArray()['id'];
        $change = $this->model()::edit($id, [
            'service_useful' => $status == '1' ? '0' : '1'
        ]);

        if ($change) {
            return "1";
        } else {
            return "0";
        }
    }

    public function serviceActivate() {
        $status = $this->requestArray()['status'];
        $id = $this->requestArray()['id'];
        $change = $this->model()::edit($id, [
            'service_active' => $status == '1' ? '0' : '1'
        ]);

        if ($change) {
            return "1";
        } else {
            return "0";
        }
    }

    protected function add(?bool $csrf = true) {
        $view_order = \model\Services::get(\model\Services::LastId())->view_order + 1;
        $this->changeRequestValue('view_order', $view_order);
        return parent::add($csrf); // TODO: Change the autogenerated stub
    }
}