<?php

namespace controller;

use ControllerScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;

class SmsGroups extends ControllerScheme
{
    const name = 'ارسال گروهی پیامک';

    protected function add(?bool $csrf = true)
    {
        $user_group = $this->requestArray()['user_group'];
        $data = $this->requestArray()['data'];
        $price = $this->requestArray()['price'];
        $count = $this->requestArray()['count'];

        switch ($user_group){
            case "1":
                if ($data=="1"){
                    $output = \model\Users::Db()->where("user_credit",'>',$price)->get();
                }else{
                    $output = \model\Users::Db()->where("user_credit",'<',$price)->get();
                }
                break;
            case "2":
                $output = \model\Users::getAllFiltered('state_id',$data);
                break;
            case "3":
                $allUsers = \model\Users::getAll();
                if ($data=="1"){
                    $output = [];
                    foreach ($allUsers as $item){
                        $payments = \model\PaymentTable::Db()->where("user_id",$item->user_id)->where("payment_status",'1')->rowCount();
                        if ($payments > $count){
                           $output[]=$item;
                        }
                    }
                }else{
                    $output = [];
                    foreach ($allUsers as $item){
                        $payments = \model\PaymentTable::Db()->where("user_id",$item->user_id)->where("payment_status",'1')->rowCount();
                        if ($payments < $count){
                            $output[]=$item;
                        }
                    }
                }
                break;
        }
        $users=[];
        foreach ($output as $value){
            $users[]=$value->user_id;
        }
        $text = $this->requestArray()['sms_text'];
        $date = strtotime('today');
        $add = $this->model()::add([
            'sms_text' => $text,
            'user_ids' => json_encode($users, JSON_UNESCAPED_UNICODE),
            'sms_group_date' => $date
        ]);

        $smsCounts = 0;
        foreach ($users as $item) {
            $mobile = \model\Users::get($item)->mobile;
            $sms = sendVerify($mobile, [$text]);
            if ($sms) {
                $smsCounts++;
            }
        }
        if ($add && $smsCounts == count($users)) {
            return showSuccessMsg('پیامک گروهی', 'ارسال');
        } else {
            return showErrorMsg('پیامک گروهی', 'ارسال');
        }




    }

    public function getSubGroup()
    {
        $val = $this->requestArray()['val'];
        switch ($val) {
            case "1":
                $res = HtmlTags::Select(".form-control#data")->Name('data')->Content(
                    HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید') .
                    HtmlTags::Option()->Value(1)->Content("انتخاب کاربرانی که موجودی بیشتر از مبلغ تعیین شده دارند") .
                    HtmlTags::Option()->Value(2)->Content("انتخاب کاربرانی که موجودی کمتر از مبلغ تعیین شده دارند")
                );

                break;
            case "2":
                $states = \model\States::getAll();
                $arrayStates = [HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید')];
                foreach ($states as $state) {
                    $arrayStates [] = HtmlTags::Option()->Value($state->state_id)->Content($state->state_name);
                }
                $res = HtmlTags::Select(".form-control#data")->Name('data')->Content(
                    implode('', $arrayStates)
                );
                break;
            case "3":
                $res = HtmlTags::Select(".form-control#data")->Name('data')->Content(
                    HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید') .
                    HtmlTags::Option()->Value(1)->Content("انتخاب کاربرانی که تراکنش بیشتر از تعداد تعیین شده دارند") .
                    HtmlTags::Option()->Value(2)->Content("انتخاب کاربرانی که تراکنش کمتر از تعداد تعیین شده دارند")
                );

                break;
        }
        return $res;
    }

}