<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use model\Entity\TopSlidersEntity;

class TopSliders extends ControllerScheme {
    use \SortRowsController;
    use ApiInterface;

    const name = 'اسلایدر';

    public static $__uploads = ["top_slider_image" => __SOURCE__ . "images/TopSliders/"];


    public function all() {
        $userId = $this->ApiParam('userId');
        $this->setIsDone();
        return self::model()::getAll()->map(function (TopSlidersEntity $top_slider) {
            return [
                'id'    => $top_slider->movie_id > 0 ? $top_slider->movie_id : $top_slider->serial_id,
                'type'  => $top_slider->movie_id > 0 ? 'movie' : 'serial',
                'image' => __IMAGES__ . '/TopSliders/' . $top_slider->slider_image,
            ];
        });
    }
}
