<?php

namespace controller;

use ControllerScheme;
use model\Entity\UsersEntity;

class Users extends ControllerScheme {
    const name = 'کاربر';

    public static $__uploads = ["user_avatar" => __SOURCE__ . "images/Users/"];

    protected function add(?bool $csrf = true)
    {
        $this->changeRequestValue('token',md5(time()));
        $this->changeRequestValue('register',strtotime('today'));
        return parent::add($csrf); // TODO: Change the autogenerated stub
    }

    public function sendTest() {
        $userId = $this->requestArray('userId');
        $user = \model\Users::get($userId);
        if ($user instanceof UsersEntity) {
            return sendPushNotification($user->firebase_token, "New Message", json_encode([
                'type'    => 'test',
                'content' => 'hi',
            ]));
        }

    }

    public function sensSMS()
    {
        $mobile = $this->requestArray()['mobile'];
        $text = $this->requestArray()['text'];
        $sms = sendVerify($mobile,[$text]);
        if ($sms){
            return '1';
        }else{
            return '2';
        }

    }

    public function sensNotif()
    {
        $id = $this->requestArray()['id'];
        $fToken = \model\Users::get($id)->firebase_token;
        $text = $this->requestArray()['text'];
        $notif = sendPushNotification($fToken, "پیام جدید", [
            'user_id'     => $id,
            'type'       => 'sendNotif',
            'text' => $text,
        ], $text);
        if ($notif){
            return "1";
        }else{
            return "2";
        }
    }

    public function chargeWallet()
    {
        $id = $this->requestArray()['id'];
        $price = $this->requestArray()['text'];
        $credit = \model\Users::get($id)->user_credit;
        $charge =\model\Users::edit($id,[
            'user_credit' => $credit + $price
        ]);
        if ($charge){
            return "1";
        }else{
            return "0";
        }
    }
}