<?php

namespace controller;

use Api\ApiInterface;
use ControllerScheme;
use FwAuthSystem\Main\UserObject;
use FwHtml\Elements\Tags\Main\HtmlTags;
use model\Entity\TopSlidersEntity;

class UsersTable extends ControllerScheme {
    use ApiInterface;

    const name = 'کاربران پنل';

    public static $__uploads = ["user_profile" => __SOURCE__ . "images/UsersTable/"];


    public function main()
    {
        $role = UserObject::instance()->getRole();
        if ($role=="AdminRole"){
            return parent::main(); // TODO: Change the autogenerated stub
        }else{
            $operators = \model\UsersTable::getAllFiltered('role_name',"OperatorRole");
            return $this->view($this->viewName(), 'main', [
                $operators,
            ]);
        }
    }

    public function changeStatus()
    {
        $status = $this->requestArray()['status'];
        $id = $this->requestArray()['id'];

        $change = $this->model()::edit($id,[
            'user_status' => $status=='1'?'0':'1'
        ]);

        if ($change){
            return "1";
        }else{
            return "0";
        }
    }

    public function checkUsername()
    {
        $val = $this->requestArray()['val'];
        $check = \model\UsersTable::getOneFiltered('user_username',$val);
        if ($check){
            return "2";
        }else{
            return "1";
        }
    }

    public function getCities()
    {
        $val = $this->requestArray()['val'];
        if (in_array(0,$val)){
            return HtmlTags::Option()->Selected()->Value('0')->Content('همه شهر ها');
        }else{
            $output=[];
            foreach ($val as $item){
                $cities = \model\Cities::getAllFiltered('state_id',$item);
                foreach ($cities as $value){
                    $output []=HtmlTags::Option()->Value($value->city_id)->Content($value->city_name);
                }
            }
            return implode('',$output);
        }

    }

    public function deactiveOperator()
    {
        $id = $this->requestArray()['id'];
        $edit = \model\UsersTable::edit($id,[
            'user_status' => 0
        ]);
        if ($edit){
            return "1";
        }else{
            return "2";
        }
    }

    public function activeOperator()
    {
        $id = $this->requestArray()['id'];
        $edit = \model\UsersTable::edit($id,[
            'user_status' => 1
        ]);
        if ($edit){
            return "1";
        }else{
            return "2";
        }
    }


}
