const Intervals = {
    // to keep a reference to all the intervals
    intervals : new Set(),

    // create another interval
    add(interval) {
        this.intervals.add(interval);
        return interval;
    },

    // create another interval
    make(...args) {
        var newInterval = setInterval(...args);
        this.intervals.add(newInterval);
        return newInterval;
    },

    // clear a single interval
    clear(id) {
        this.intervals.delete(id);
        return clearInterval(id);
    },

    // clear all intervals
    clearAll() {
        this.intervals.forEach(e => clearInterval(e));
    }
};
function GoToUrl(url, element = null, disableErrors = false) {
    Intervals.clearAll();
    $.loader();
    let controllerType = "main";
    url = url.toString();
    let firstIndex = url.indexOf('^'), lastIndex = url.lastIndexOf("^");
    if (firstIndex >= 0 && lastIndex > firstIndex) {
        controllerType = url.substr(firstIndex, lastIndex).replace("^", "").trim();
        url = url.replace(controllerType, "").replace(/\^/g, "");
    }
    $.ajax({
        url: `controllers/${url}`,
        type: "POST",
        data: {
            controller_type: controllerType,
            fw_referrer: Referrer,
        },
        error: error => {
            if (error.status == 403 || error.status == 404) {
                $.loader();
                Swal.fire({
                    icon: 'info',
                    title: 'صفحه ی مورد نظر در حال طراحی است!',
                    confirmButtonText: 'تایید'
                })
            } else {
                let timerInterval;
                $.loader();
                Swal.fire({
                    icon: 'error',
                    title: 'خطای ناشناخته!',
                    html: 'شما در <b></b> میلی ثانیه به صفحه ی اصلی منتقل میشوید',
                    timer: 3000,
                    timerProgressBar: !0,
                    onBeforeOpen: () => {
                        Swal.showLoading();
                        timerInterval = setInterval(() => {
                            Swal.getContent().querySelector('b').textContent = Swal.getTimerLeft()
                        }, 100)
                    },
                    onClose: () => {
                        clearInterval(timerInterval)
                    }
                }).then((result) => {
                    if (result.dismiss === Swal.DismissReason.timer)
                        location.reload()
                })
            }
        },
        cache: !1, async: !0,
        success: res => {
            $.loader();
            if ($(this).hasClass('nav-link')) {
                $('.nav-link').removeClass('active');
                $(this).addClass('active');
            }
            $('.tooltip').hide();
            $("#fw-content").html(res).find('[data-toggle=tooltip]').tooltip();
            const url = $("#fw_current_page_url_new").val();
            const title = $("#fw_current_page_title").val();
            window.document.title = `${window.document.title.split('-')[0]} - ${title}`;
            window.history.pushState({urlPath: url}, window.document.title, url);

            if (url !== Referrer) {
                Referrer = url;
            }
        }
    });
}


let Referrer = "";
$.Ajax = function () {

}
$(document).on('click', '.ajax', function (e) {
    e.preventDefault();

    let url = $(this).attr('rel');
    if ($(this).attr('rel').includes('.fwTools')) {
        if (Swal.isVisible()) {
            Swal.close();
        }
        $('.modal').modal("hide");
        $.loader();
        e.preventDefault();

        let myUrl, controller, view;
        myUrl = $(this).attr('rel');
        if (myUrl === 'undefined' || !myUrl) {
            $.loader();
            Swal.fire({
                icon: 'info',
                title: 'صفحه ی مورد نظر در حال طراحی است!',
                confirmButtonText: 'تایید'
            });
            return false;
        }
        myUrl = myUrl.replace('.php', '');

        let date = new Date();
        let controller_type = '';
        myUrl = myUrl.replace('.fwTools', '');
        controller = "controller/" + myUrl;
        if (myUrl.includes('edit')) {
            controller = "controller/" + myUrl.replace('edit', '');
            controller_type = 'get';
        } else if (myUrl.toLowerCase().includes('view')) {
            controller = "controller/" + myUrl.replace('view', '');
            controller_type = 'get';
        } else if (myUrl.includes('delete')) {
            controller = "controller/" + myUrl.replace('delete', '');
            controller_type = 'get';
        } else if (myUrl.includes('add')) {
            controller = "controller/" + myUrl.replace('add', '')
        }
        controller = 'fwTools/' + controller;
        view = "fwTools/view/" + myUrl

        let controller_data = controller_type !== '' ? {
            ajax_type: 'internal',
            controllerPathToInclude: controller,
            controller_type: controller_type,
        } : {
            controllerPathToInclude: controller,
            ajax_type: 'internal'
        };
        $.ajax({
            data: controller_data,
            type: "POST",
            url: controller, success: rt => {
                $.ajax({
                    url: view,
                    data: {
                        data: rt.split('||||||')[1],
                        controller: controller,
                        timeStampForAjaxRequest: date.getTime()
                    },
                    type: "POST",
                    success: page => {

                        $("#fw-content").empty().html(page);
                        $(".tooltip").hide();
                        $.loader();

                    },
                    error: error => {
                        if (error.status == 403 || error.status == 404) {
                            $.loader();
                            Swal.fire({
                                icon: 'info',
                                title: 'صفحه ی مورد نظر در حال طراحی است!',
                                confirmButtonText: 'تایید'
                            })
                        } else {
                            let timerInterval;
                            $.loader();
                            Swal.fire({
                                icon: 'error',
                                title: 'خطای ناشناخته!',
                                html: 'شما در <b></b> میلی ثانیه به صفحه ی اصلی منتقل میشوید',
                                timer: 3000,
                                timerProgressBar: !0,
                                onBeforeOpen: () => {
                                    Swal.showLoading();
                                    timerInterval = setInterval(() => {
                                        Swal.getContent().querySelector('b').textContent = Swal.getTimerLeft()
                                    }, 100)
                                },
                                onClose: () => {
                                    clearInterval(timerInterval)
                                }
                            }).then((result) => {
                                if (result.dismiss === Swal.DismissReason.timer)
                                    location.reload()
                            })
                        }
                    }
                })
            },
            cache: !1, async: !0
        });

    } else {

        if (url !== '' && url !== null && url !== 'undefined') {
            GoToUrl(url, this);
        } else {
            showError({
                title: 'خطایی رخ داد',
                text: 'صفحه ی مورد نظر یافت نشد'
            });
        }
    }
})

$.Ajax();

$(window).on('load', () => $("#fw-preloader").addClass('loaded'));
window.onpopstate = function (e) {
    if (Referrer) {
        GoToUrl(e.state.urlPath);
    }
}
window.onload = function (e) {
    const url = location.href.split('/').pop();
    if (url !== 'index') {
        GoToUrl(`${url}@main`, null, true);
    }
}
