<?php

use helpers\action\Actions;
use FwAuthSystem\Main\UserObject;

class ControllerScheme extends Controller {
	const name = 'Controller';
	protected static $__uploads = [];
	protected static $__defaults = [];
	public $fireView = true;
	
	
	final public function __construct($ModelInstance = NULL) {
		try {
			parent::__construct($ModelInstance);
		} catch(ControllerException $e) {
			echo "<kbd>{$e->getMessage()}</kbd>";
		}
	}
	
	public function GetLabels() {
		return $this->view($this->viewName(), 'labels', [
			[],
		]);
	}
	
	public function main() {
		return $this->view($this->viewName(), 'main', [
			$this->model()->getAll(),
		]);
	}
	
	public function editIndex($key = '0') {
		return $this->view($this->viewName(), 'editIndex', [
			($this->model()::get($key > 0 ? $key : cleanMe($this->key_value()))),
		]);
	}
	
	public function deleteIndex($key = '0') {
		return $this->view($this->viewName(), 'deleteIndex', [
			($this->model()->get($key > 0 ? $key : cleanMe($this->key_value()))),
		]);
	}
	
	public function viewIndex($key = '0') {
		return $this->view($this->viewName(), 'viewIndex', [
			($this->model()->get($key > 0 ? $key : cleanMe($this->key_value()))),
		]);
	}
	
	public function addIndex() {
		return $this->view($this->viewName(), 'addIndex', [
		]);
	}
	
	public function edit() {
		$array = $this->requestArray();
		foreach ((isset($this::$__defaults) ? $this::$__defaults : []) as $key => $defaultValue) {
			if (!isset($array[$key])) {
				$array[$key] = $defaultValue;
			}
		}
		foreach ((isset($this::$__uploads) ? $this::$__uploads : []) as $name => $path) {
			if (isset($_FILES[$name]) && strlen($_FILES[$name]['name']) > 0) {
				$deletable = (object)deStr($this->model()->get($this->key_value()));
				if ($deletable->$name !== 'default.png' || $deletable->$name !== 'default.jpg') {
					if (file_exists($path . $deletable->$name) and !is_dir($path . $deletable->$name)) {
						unlink($path . $deletable->$name);
					}
				}
				$checkImage = checkImage($this->requestArray());
				$fileName = uploadImage($_FILES[$name], $checkImage, $path, $checkImage !== false, $name);
				$array[$name] = $fileName;
			}
		}
		$this->setRequestArray($array);
		$array = [];
		$array['data_before_action'] = json_encode($this->model()::get($this->key_value()), JSON_UNESCAPED_UNICODE);
		$array['data_after_action'] = json_encode(checkAll($this->requestArray(), true), JSON_UNESCAPED_UNICODE);
		$array['admin_id'] = UserObject::instance()->getUserId();
		$array['date'] = time();
		$array['action_type'] = 'edit';
		$array['row_id'] = $this->key_value();
		$array['tblName'] = $this->model()->_table;
		Actions::add($array);
		return $this->view($this->viewName(), 'edit', [
			$this->model()->edit($this->key_value(), checkAll($this->requestArray(), true)),
		]);
	}
	
	public function addQuick() {
		$lastId = $this->model()::LastId();
		$this->fireView = false;
		$this->add(false);
		$newId = $this->model()::LastId();
		if ($newId > $lastId) {
			$item = $this->model()::get($newId);
			return json_encode([
				'isDone' => true,
				'option' => $item->toOption(),
				'id'     => $newId,
			], JSON_UNESCAPED_UNICODE);
		}
		return json_encode(['isDone' => false]);
	}
	
	protected function add(?bool $csrf = true) {
		$csrf = ($csrf !== false);
		$array = $this->requestArray();
		foreach ((isset($this::$__defaults) ? $this::$__defaults : []) as $key => $defaultValue) {
			if (!isset($array[$key])) {
				$array[$key] = $defaultValue;
			}
		}
		foreach ((isset($this::$__uploads) ? $this::$__uploads : []) as $name => $path) {
			if (isset($_FILES[$name]['name']) and strlen($_FILES[$name]['name']) > 0) {
				if (!is_dir($path)) {
					mkdir($path, 0775);
				}
				$checkImage = checkImage($this->requestArray());
				if ($checkImage) {
					$fileName = uploadImage($_FILES[$name], $checkImage, $path, true, $name);
				} else {
					$fileName = uploadImage($_FILES[$name], $checkImage, $path, false, $name);
				}
				if (!isset($array[$name])) {
					$array[$name] = $fileName;
				}
			}
		}
		$this->setRequestArray($array);
		$id = $this->model()->add(checkAll($this->requestArray(), $csrf == true));
		if ($id > 0) {
			$array = [];
			$array['data_before_action'] = json_encode([]);
			$array['data_after_action'] = json_encode(checkAll($this->requestArray(), $csrf), JSON_UNESCAPED_UNICODE);
			$array['admin_id'] = UserObject::instance()->getUserId();
			$array['date'] = time();
			$array['action_type'] = 'add';
			$array['row_id'] = $id;
			$array['tblName'] = $this->model()->_table;
			Actions::add($array);
		}
		if ($this->fireView) {
			return $this->view($this->viewName(), 'add', [
				$id,
			]);
		}
	}
	
	public function showInOption(object $item) : string {
		return '';
	}
	
	public function quickAdd() {
		$Instance = $this->ViewInstance();
		if ($Instance instanceof View) {
			if (method_exists($Instance, 'quickAddForm')) {
				return $Instance->quickAddForm();
			} elseif (method_exists($Instance, 'Form')) {
				return $Instance->Form();
			}
		}
		return NULL;
	}
	
	public function ViewInstance() {
		
		if (!class_exists($this->viewName())) {
			$this->loadView();
		}
		$className = $this->viewName();
		$Instance = new $className($this);
		if ($Instance instanceof View) {
			return $Instance;
		}
		return NULL;
	}
	
	protected function delete() {
		$deletable = $this->model()->get($this->key());
		foreach ($this::$__uploads as $name => $path) {
			if ($deletable->$name !== 'default.png' || $deletable->$name !== 'default.jpg') {
				if (file_exists($path . $deletable->$name) and !is_dir($path . $deletable->$name)) {
					unlink($path . $deletable->$name);
				}
			}
		}
		$array = [];
		$array['data_before_action'] = json_encode($this->model()::get($this->key_value()), JSON_UNESCAPED_UNICODE);
		$array['data_after_action'] = json_encode([]);
		$array['admin_id'] = UserObject::instance()->getUserId();
		$array['date'] = time();
		$array['action_type'] = 'delete';
		$array['row_id'] = $this->key_value();
		$array['tblName'] = $this->model()->_table;
		Actions::add($array);
		return $this->view($this->viewName(), 'delete', [
			$this->model()->delete(cleanMe($this->key_value())),
		]);
	}

	
}
