<?php

use DOMWrap\Document;
use FwHtml\FontAwesome;
use FwHtml\Elements\Tags\Main\HtmlTags;
use DATABASE\ORM\Interact\Entities\EntityScheme;

trait SortRowsView {
	
	public function sortButton() {
		return $this->Html()->topBtn($this->generatePath('sort', []), 'ترتیب نمایش', FontAwesome::Sort_numeric_asc(), 'warning', true);
	}
	
	public function sort(Document $document) {
		
		$document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
				->Content(
					HtmlTags::Div('.row')
						->Content(
							HtmlTags::Div('.col-md-12')->Content(
								HtmlTags::Div('.card.card-primary.card-outline')
									->Content(
										HtmlTags::Div('.card-header')
											->Content(
												$this->Html()->CardTitle(),
												$this->Html()->refreshAndAdd()
											),
										HtmlTags::Div('.card-body.d-flex.flex-wrap')
											->Content(
												HtmlTags::Ul(".d-flex.flex-column.w-100#sortable")->Content(
													$this->getData()->map(function (EntityScheme $process) {
														return HtmlTags::Li('.ui-state-default.p-3')->Data_('id', $process->{$process->model()->_key})->Attrs(['style' => 'border-bottom: grey 1px solid'])->Content(
															HtmlTags::I('.ml-2')->Class(FontAwesome::Arrows_v()),
															HtmlTags::Span()->Content(
																$process->sortName()
															),
															$this->Html()->editBtn($process)->Class('float-left m-0')
														);
													})->join('')
												)
											),
										HtmlTags::Div('.card-footer')->Content(
											HtmlTags::Button('.btn.btn-success.w-100#submit')->Content(
												"ثبت نهایی"
											)
										)
									)
							)
						)
				);
	}
}
