<?php

namespace site\helpers;

use DATABASE\ORM\QueryBuilder\QueryBuilder\Db;
use fwJson\Json;
use model\ChatMessages;
use model\Entity\MembershipsEntity;
use model\Entity\ProductsEntity;
use model\Memberships;
use model\Products;
use model\Users;
use payment\BasePayment;

class ZarinPalPayment extends BasePayment {
    const MerchantCode = '83c76224-8a20-4abf-9ee7-4775b1c01cc7';
    const Action_url = 'https://www.zarinpal.com/pg/StartPay/';
    const CallBack_url = 'https://api.internetcafe.parsa.today/callback';
    const Confirm_url = 'https://api.zarinpal.com/pg/v4/payment/verify.json';

    protected $OrderData;

    public function OrderData(Json $json) {
        $this->OrderData = $json;
    }

    public function goToPayment() {
        $this->CreateResNum();
        $user_data = $this->UserModel->get($this->UserData->{$this->UserModel->_key});
        $this->PaymentModel->save($user_data->{$this->UserModel->_key}, $this->_amount, $this->ResNum, $this->OrderData, $this->type, "زرین پال");
        $data = [
            "merchant_id"  => self::MerchantCode,
            "amount"       => $this->_amount >= 50000000 ? 49999999 : $this->_amount,
            "callback_url" => self::CallBack_url,
            "description"  => "پرداخت با کد رهگیری: {$this->ResNum}",
            "metadata"     => [
                "email"  => "info@karo-app.com",
                "mobile" => str("{$user_data->{$this->UserModel->UserMobile($this->_user_id)}}")->len() > 0 ? "{$user_data->{$this->UserModel->UserMobile($this->_user_id)}}" : "09396329984",
                "resnum" => $this->ResNum,
            ],
        ];
        $jsonData = json_encode($data);
        $ch = curl_init('https://api.zarinpal.com/pg/v4/payment/request.json');
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v1');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData),
        ]);
        $result = curl_exec($ch);
        $err = curl_error($ch);
        $result = json_decode($result, true, JSON_PRETTY_PRINT);
        curl_close($ch);
        if ($err) {
            return $err;
        } else {
            if (empty($result['errors'])) {
                if ($result['data']['code'] == 100) {
                    $paymentId = $this->PaymentModel::Db()->orderBy('payment_id', true)->limit(1)->get()->first->payment_id;
                    $this->PaymentModel::edit($paymentId, [
                        $this->PaymentModel->ResNumField() => $result['data']["authority"],
                    ]);
                    return 'https://zarinpal.com/pg/StartPay/' . str_replace("\n", "", trim($result['data']["authority"]));
                }
            } else {
                return $result['errors']['message'];
            }
        }
        return "پاسخی از درگاه دریافت نشد";
    }


    public function update($resnum, $refnum): bool {
        $resField = $this->PaymentModel->ResNumField();
        $refField = $this->PaymentModel->RefNumField();
        $paymentData = $this->PaymentModel::Db()->where($resField, $resnum)->get()->first;
        return $this->PaymentModel::Db()->where($resField, $resnum)->update([
            $refField        => $refnum,
            'payment_status' => 1,
        ]);
    }

    public function getResult($Authority): array {
        $PaymentData = $this->PaymentModel::getOneFiltered($this->PaymentModel->ResNumField(), $Authority);
        $data = [
            "merchant_id" => \site\helpers\ZarinPalPayment::MerchantCode,
            "authority"   => $Authority,
            "amount"      => $PaymentData->payment_amount,
        ];
        $jsonData = json_encode($data);
        $ch = curl_init(self::Confirm_url);
        curl_setopt($ch, CURLOPT_USERAGENT, 'ZarinPal Rest Api v4');
        curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
        curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            'Content-Type: application/json',
            'Content-Length: ' . strlen($jsonData),
        ]);
        $result = curl_exec($ch);
        curl_close($ch);
        return [
            $PaymentData,
            json_decode($result, true)
        ];
    }

}
