<?php

namespace site\helpers;

use fwJson\Json;
use model\Users;
use model\Orders;
use model\Memberships;
use payment\BasePayment;
use model\Entity\MembershipsEntity;

class PasargadPayment extends BasePayment {
	const MerchantId = '5172378';
	const TerminalId = '2438349';
	const Action_url = 'https://pep.shaparak.ir/payment.aspx?n=Token';
	const CallBack_url = 'https://weview.site/admin/callback';
	const Confirm_url = 'https://pep.shaparak.ir/Api/v1/Payment/VerifyPayment';
	
	protected $OrderData;
	
	public function OrderData(Json $json) {
		$this->OrderData = $json;
	}
	
	public function goToPayment() {
		$this->CreateResNum();
		$user_data = $this->UserModel->get($this->UserData->{$this->UserModel->_key});
		$this->PaymentModel->save($user_data->{$this->UserModel->_key}, $this->_amount, $this->ResNum, $this->OrderData, $this->type, "پاسارگاد");
		$data = [
			"InvoiceNumber"   => "$this->ResNum",
			"InvoiceDate"     => date("Y-m-d H:i:s"),
			"Timestamp"       => date("Y-m-d H:i:s"),
			"TerminalCode"    => static::TerminalId,
			"Action"          => '1003',
			"MerchantCode"    => static::MerchantId,
			"Amount"          => "$this->_amount",
			"RedirectAddress" => self::CallBack_url,
		];
		$jsonData = json_encode($data);
		$ch = curl_init('https://pep.shaparak.ir/Api/v1/Payment/GetToken');
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			'Content-Type: application/json',
			'Sign: ' . base64_encode(json_encode($jsonData)),
		]);
		$result = curl_exec($ch);
		$err = curl_error($ch);
		$result = json_decode($result, true, JSON_PRETTY_PRINT);
		curl_close($ch);
		if ($err) {
			return $err;
		} else {
			if ($result['IsSuccess']) {
				return self::Action_url.$result['Token'];
			} else {
				return $result['Message'];
			}
		}
		return "پاسخی از درگاه دریافت نشد";
	}
	
	
	public function update($resnum, $refnum) {
		$resField = $this->PaymentModel->ResNumField();
		$refField = $this->PaymentModel->RefNumField();
		$paymentData = $this->PaymentModel::Db()->where($resField, $resnum)->get()->first;
		$data = json_decode($paymentData->payment_data);
		/** @var MembershipsEntity $membership */
		$membership = Memberships::get($data->membershipId);
		Users::edit($data->userId, [
			'membership_id'   => $data->membershipId,
			'membership_date' => $data->date + ($membership->time * 86400),
		]);
		return $this->PaymentModel::Db()->where($resField, $resnum)->update([
			$refField        => $refnum,
			'payment_status' => 1,
		]);
	}
	
	public function getResult($resnum) {
		$PaymentData = $this->PaymentModel::getOneFiltered($this->PaymentModel->ResNumField(), $resnum);
		$data = [
			"InvoiceNumber"   => "$resnum",
			"InvoiceDate"     => date("Y-m-d H:i:s",$PaymentData->payment_date),
			"Timestamp"       => date("Y-m-d H:i:s",$PaymentData->payment_date),
			"TerminalCode"    => static::TerminalId,
			"MerchantCode"    => static::MerchantId,
			"Amount"          => "$PaymentData->payment_amount",
		];
		$jsonData = json_encode($data);
		$ch = curl_init(self::Confirm_url);
		curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'POST');
		curl_setopt($ch, CURLOPT_POSTFIELDS, $jsonData);
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		curl_setopt($ch, CURLOPT_HTTPHEADER, [
			'Content-Type: application/json',
			'Sign: ' . base64_encode(json_encode($jsonData)),
		]);
		$result = curl_exec($ch);
		curl_close($ch);
		return [$PaymentData, json_decode($result, true)];
	}
	
}
