<?php
namespace FwBase\Reports;
use ControllerScheme;
use FwHtml\Elements\Attrs\Style;
use FwHtml\Elements\Tags\Main\HtmlTags;
use helpers\PaymentStatus;

abstract class ReportScheme extends ControllerScheme {
    public function main() {
        return $this->view($this->viewName(),'start',[

        ]);
    }
    abstract public function getReport();
    public function start(){
        return $this->main();
    }
    final protected function isSet(string $field_name,callable $function = null) {
        $output = ((isset($this->requestArray()['filters'][$field_name]) and $this->requestArray()['filters'][$field_name] != '') ? $this->requestArray()['filters'][$field_name] : null);
        if ($function)
            return $function($output);
        return $output;
    }

    final static public function timeToQuery($field,$startValue,$endValue){
        $query = [];
        if ($startValue){
            $query[] = "$field >= $startValue";
        }
        if ($endValue){
            $query[] = "$field <= $endValue";
        }
        return implode(' and ',$query);
    }
}
