<?php

use model\Icons;
use model\Files;
use DATABASE\Model;
use DOMWrap\Document;
use FwHtml\FontAwesome;
use model\Entity\FilesEntity;
use FwAuthSystem\Main\UserObject;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Base\TagsClass;

include __SOURCE__ . 'dist/php/Views/ViewClass.php';
include __SOURCE__ . 'dist/php/Views/ViewPagination.php';

abstract class View {
	public $thisView = 'null';
	public $SingularName = '';
	public $PluralName = '';
	public $labels = [];
	public $fill = false;
	public $disableAll = false;
	public $initDataTable = true;
	public $initSelect2 = true;
	private $html;
	private $Controller;
	private $Data;
	private $state;
	private $isSubmitted = false;
	/**
	 * @var string
	 */
	private $controllerPath = 'null';
	private $quick_add_count = 0;
	/**
	 * @var array
	 */
	private $quickAdds = [];
	private $scripts = [];
	
	
	final public function __construct(Controller &$Controller = NULL, $Data = NULL) {
		
		$this->Data = $Data;
		$this->Controller = $Controller;
		$this->configThis();
		$this->setControllerPath($this->Controller()->RelPath());
		$this->html = new Views\Html($this);
	}
	
	private function configThis() {
		$url = collect(explode('/controllers/', $_SERVER['REQUEST_URI']))->last;
		$pure = explode('?', collect(explode('/', $url))->last)[0];
		if ($this->State() != 'main') $pure = $this->State() . $pure;
		if (strpos($url, '?') !== false) $pure .= '?' . explode('?', collect(explode('/', $url))->last)[1];
		$this->thisView = $this->currentDir() . '/' . $pure;
	}
	
	public function State() {
		return $this->state;
	}
	
	public function currentDir() {
		return str(collect(str($this->Controller()->Path())->explode(DIRECTORY_SEPARATOR))->removeLast()->join(DIRECTORY_SEPARATOR))->replace("controllers", 'views')->getValue();
	}
	
	public function Controller() : Controller {
		return $this->Controller;
	}
	
	private function setControllerPath(string $string) {
		$this->controllerPath = "controllers/$string";
	}
	
	public function edit(Document $document) {
		$document->html = showResult($this->getData(), $this->SingularName(), 'ویرایش');
	}
	
	public function getData() {
		return $this->Data;
	}
	
	public function SingularName() : string {
		return $this->SingularName;
	}
	
	final public function generatePath(string $state = '', array $arguments = []) {
		$path = str($this->Controller()->RelPath());
		$path = collect($path->explode(DIRECTORY_SEPARATOR));
		if ($state != '') $state = "^$state^";
		$path->last = $path->last();
		$path = $state . $path->join(DIRECTORY_SEPARATOR);
		$path = $this->argumentToQueryString($arguments, $path);
		return $path;
	}
	
	final public static function argumentToQueryString(array $arguments, string $path) {
		$args = [];
		foreach ($arguments as $key => $value) {
			$args[] = "$key=$value";
		}
		if (sizeof($args) > 0) {
			$path = "$path?" . implode('&', $args);
		}
		return $path;
	}
	
	public function delete(Document $document) {
		$document->html = showResult($this->getData(), $this->SingularName(), 'حذف');
	}
	
	public function FilePicker($name, array $options = []) : string {
		$file = Files::get($this->getData()->$name);
		return HtmlTags::Button(".btn.w-100" . ($file instanceof FilesEntity ? ".btn-success" : ".btn-primary") . ".filePicker")->Data_('options', json_encode($options))->Content(
				HtmlTags::Input()->Type('hidden')->Name($name)->Value((isset($file) ? $file->id() : 0)),
//				HtmlTags::I()->Class(FontAwesome::File_o()),
				HtmlTags::Span('.mr-1')->Content(
					isset($file) ? $file->thumb() : "انتخاب فایل",
                    " ",
                    isset($file) ? $file->name() : ""
                ),
            )->Type('button') . $this->filePickerModal();
	}
	
	private function filePickerModal() {
		return HtmlTags::Div(".modal.fade#filePickerModal")->Content(
				HtmlTags::Div('.modal-dialog.modal-lg')->Content(
					HtmlTags::Div('.modal-content')->Content(
						HtmlTags::Div('.modal-header')->Content(
							HtmlTags::H4('.modal-title')->Content(
								"انتخاب فایل"
							),
							HtmlTags::Div('.pull-left')->Content(
								HtmlTags::Button('.close')->Content('&times;')->Data_('dismiss', 'modal')->Type('button')
							)
						),
						HtmlTags::Div('.modal-body#filePickerContent')->Content()
					)
				)
			) ;
	}
	
	
	public function quickAdd(string $Select, \ControllerScheme $controllerToAddTo, ?string $waitFor = '', ?\ControllerScheme $beforeController = NULL) {
		$this->quick_add_count++;
		$this->quickAdds[] = $this->quickAddModal($controllerToAddTo);
		return HtmlTags::Div('.input-group.w-100')->Content(
			HtmlTags::Div('.input-group-prepend')->Content(
				HtmlTags::Button('.btn.btn-success.quickAddBtn')->Content(
					HtmlTags::I()->Class(FontAwesome::Plus())
				)->Attrs(['type' => 'button'])
					->Data_('modal', "quick_add_{$this->quick_add_count}")->Data_('wait', "$waitFor")
					->Data_('before_name', ($beforeController != NULL ? $beforeController::name : ''))
			) .
			HtmlTags::Div('.quick-add-div.w-75')->Content(
				$Select
			)
		);
	}
	
	private function quickAddModal(\ControllerScheme $controller) {
		$name = $controller::name;
		return HtmlTags::Div(".modal.fade#quick_add_{$this->quick_add_count}")->Content(
				HtmlTags::Div('.modal-dialog.modal-lg')->Content(
					HtmlTags::Div('.modal-content')->Content(
						HtmlTags::Div('.modal-header')->Content(
							HtmlTags::H4('.modal-title')->Content(
								"افزودن سریع {$name}"
							),
							HtmlTags::Div('.pull-left')->Content(
								HtmlTags::Button('.close')->Content('&times;')->Data_('dismiss', 'modal')->Type('button')
							)
						),
						HtmlTags::Form()->Content(
							'<form class="quickAddForm" action="' . $controller->SoftPath('', false) . '">' .
							HtmlTags::Div('.modal-body.d-flex.flex-wrap')->Content(
								$controller->quickAdd()
							),
							HtmlTags::Div('.modal-footer')->Content(
								HtmlTags::Button('.btn.btn-danger.float-right.mr-0.ml-auto')->Content(
									HtmlTags::I()->Class(FontAwesome::Times()),
									' انصراف '
								)->Data_('dismiss', 'modal'),
								HtmlTags::Button('.btn.btn-primary.quick-add-submit_button')->Content(
									HtmlTags::I()->Class(FontAwesome::Check()),
									' ثبت '
								)->Attrs(['type' => 'button'])
							)
							. '</form>'
						)
					)
				)
			) . $controller->ViewInstance()->Script('add');
	}
	
	public function Script(?string $state = '') {
		$output = [];
		if ($state == '') {
			$state = $this->State();
		}
		$prod = FwConfig::PROD();
		foreach (new RegexIterator(new RecursiveIteratorIterator(new RecursiveDirectoryIterator($this->currentDir())), '/\.js/') as $phpFile) {
			$fileName = $phpFile->getFileName();
			$fileName = str_replace('.js', '', $fileName);
			$view = collect(str($this->Controller()->RelPath())->explode(DIRECTORY_SEPARATOR))->last();
			$fileName = str_replace("$view.view.", '', $fileName);
			$fileName = str_replace("OR", '|', $fileName);
			if (preg_match('/' . $fileName . '/', $state) == true) {
				$time = time();
				if ($prod) {
					$time = 1;
				}
				$output[] = '<script type="module" src="js/' . str_replace(__SOURCE__ . 'views/', '', $this->currentDir()) . '/' . $phpFile->getFileName() . '?t=' . $time . '"></script>';
			}
		}
		foreach ($this->scripts as $script) {
			$output[] = $script;
		}
//		echo nl2br(htmlentities(implode('\n',$output))).'<br>';
		return implode('', $output);
	}
	
	final public function Path() {
		return (new ReflectionClass($this))->getFileName();
	}
	
	public function doFill() {
		$this->fill = true;
	}
	
	/**
	 */
	public function doDisableAll() {
		$this->disableAll = true;
	}
	
	/**
	 * @return bool
	 */
	public function isDisableAll() : bool {
		return $this->disableAll;
	}
	
	public function labels() {
		$Document = new \DOMWrap\Document();
		$this->addIndex($Document);
		echo optOfArray((object)$this->labels, 'data', 'data', false, ['value' => 'text'], false);
		die();
	}
	
	public function add(Document $document) {
		$document->html = showResult($this->getData(), $this->SingularName(), 'افزودن');
	}
	
	public function Process($state) {
		$this->state = $state;
		$Document = new Document();
		if (method_exists($this, $state)) {
			$this->$state($Document);
			if ((str($state))->includes('add') || (str($state))->includes('edit') or (str($state))->includes('delete')) {
				$this->submit();
				$script = '<script src="src/dist/js/selectIcon.js"></script>';
				$script .= '<script src="src/dist/js/final_submit.js"></script>';
			} else
				$script = '<script src="src/dist/js/activation.js"></script>';
			$Document->script .= $this->Script();
			$className = collect(explode('\\', $this->Controller()->class()))->last;
			return hiddenInput($className, '', 'fw_current_page_url_new') . $Document->saveHTML() . $Document->script . hiddenInput(collect(str(get_class($this))->explode('\\'))->last . '@' . $this->State(), '', 'fw_current_page_url_new') . hiddenInput($this->PluralName(), '', 'use_current_page_title') . hiddenInput($this->PluralName(), '', 'fw_current_page_title') . $script;
		} else {
			return $this->NotFoundError(get_class($this), $state);
		}
	}
	
	protected function submit() {
		if ($this->isSubmitted === false) {
			echo '<script>$.submit("' . $this->getControllerPath() . '")</script>';
			$this->isSubmitted = true;
		}
	}
	
	/**
	 * @return mixed
	 */
	public function getControllerPath() {
		return $this->controllerPath;
	}
	
	public function PluralName() : string {
		return ($this->PluralName ? $this->PluralName : $this->SingularName() . ' ها');
	}
	
	private function NotFoundError(string $get_class, $state) {
		return HtmlTags::Section('.content')->Content(HtmlTags::Div('.row')->Content(HtmlTags::Div('.col-md-12')->Content(HtmlTags::Div('.card.card-warning.mt-5')->Content(HtmlTags::Div('.card-header')->Content(HtmlTags::H4('خطایی رخ داد!'), HtmlTags::Div('.card-tools')->Content($this->Html()->backBtn())), HtmlTags::Div('.card-body')->Content(HtmlTags::H3("متود $state در کلاس $get_class یافت نشد!"), HtmlTags::Br(), HtmlTags::H5()->Content("کنترلر: {$this->Controller()->class()}"), HtmlTags::H5()->Content("آدرس کنترلر: {$this->Controller()->SoftPath('.php')}"), HtmlTags::Br(), HtmlTags::H5()->Content("مدل: {'$this->Controller()->model()->class()'}"))))));
	}
	
	public function Html() : \Views\Html {
		return $this->html;
	}
	
	public function Polygon(string $name, string $listen = '') {
		
		$res = '<div class="form-group col-md-12">
                                <label>لطفا محدوده ' . $this->SingularName() . ' را مشخص کنید</label>
                                <div class="map" id="map">
                                </div>
                                <div>
                                    <input type="hidden" name="' . $name . '" id="map-coords">
                                </div>
                            </div>';
		$listen = ($listen !== '' ? "listen: '$listen'" : '');
		if ($this->fill === true) {
			$coordsArr = explode(")", str_replace("(", "", $this->getData()->$name));
			$firstPos = explode(",", $coordsArr[0]);
			$polygon = '[';
			foreach ($coordsArr as $coords) {
				if ($coords != "") {
					$point = explode(',', $coords);
					$polygon .= "[" . $point[0] . ',' . $point[1] . '],';
				}
			}
			$polygon .= ']';
			$res .= '<script>
$.initMap({
    view: [' . $firstPos[0] . ',' . $firstPos[1] . '],
    polygon: ' . $polygon . ',
    disable: ' . (strpos($this->thisView, "delete") !== false ? "true" : "false") . ',
    ' . $listen . '
})';
		} else {
			$res .= '<script>
    $.initMap({
    disable: ' . (strpos($this->thisView, "delete") !== false ? "true" : "false") . ',
    ' . $listen . '
    });</script>';
		}
		return $res;
	}
	
	public function MapMarker(string $lat, string $long) {
		$firstValue = '35.69299463209881';
		$secondValue = '51.33911132812501';
		if ($this->fill) {
			$firstValue = $this->getData()->$lat;
			$secondValue = $this->getData()->$long;
		}
		return HtmlTags::Div('#map.map') . "<script>$(function () {
        let map = L.map('map').setView([$firstValue, $secondValue], 8);
        L.tileLayer('https://api.mapbox.com/styles/v1/{id}/tiles/{z}/{x}/{y}?access_token=pk.eyJ1IjoiZmFyaGFkamFmYXJpMzg1IiwiYSI6ImNqanF5dmpvNjhmZXgzdm82cHljbDdhb2UifQ.VGrzePHsYotiYRCe9cDr4A', {
            maxZoom: 18,
            minZoom: 5,
            id: 'mapbox/streets-v11',
            tileSize: 512,
            zoomOffset: -1,
            accessToken: 'pk.eyJ1IjoiZmFyaGFkamFmYXJpMzg1IiwiYSI6ImNqanF5dmpvNjhmZXgzdm82cHljbDdhb2UifQ.VGrzePHsYotiYRCe9cDr4A'
        }).addTo(map);
        let marker = L.marker([$firstValue, $secondValue]).addTo(map);

        function onMapClick(e) {
//            alert(e)
            map.removeLayer(marker);
            marker = L.marker(e.latlng).addTo(map);
            $(\"#$lat\").val(e.latlng.lat);
            $(\"#$long\").val(e.latlng.lng);
        }

        map.on('click', onMapClick);
    });</script>" . $this->Html()->Input($lat)->Type('hidden') . $this->Html()->Input($long)->Type('hidden');
	}
	
	public function __call($name, $arguments) {
		return $this->Html()->$name();
	}

    public function show(array $arrayOfIndexed, bool $showDelete = true, bool $showEdit = true, bool $showActive = false, bool $showView = false, ...$actionBtn) {

        $result = '';
        $canEdit = UserObject::canEdit($this->Controller());
        $canDelete = UserObject::canDelete($this->Controller());
        $canActivate = UserObject::canActivate($this->Controller());
        $userObject = UserObject::instance();
        foreach (@$this->getData() as $item) {
            if (UserObject::canSee($this->Controller(), $item, $userObject)) {
                $result .= '<tr><td></td>';
                foreach ($arrayOfIndexed as $index => $value) {
                    if (is_string($index) and is_callable($value)) {
                        $reflect = new ReflectionFunction($value);
                        switch (sizeof($reflect->getParameters())) {
                            case 0:
                                $result .= "<td>{$value()}</td>";
                                break;
                            case 1:
                                $result .= "<td>{$value($item->{$index})}</td>";
                                break;
                            case 2:
                                $result .= "<td>{$value($item->{$index},$item)}</td>";
                                break;
                        }
                    }
                    if (is_string($index) and is_string($value)) {
                        if (class_exists($value)) {
                            $value = new $value();
                            if ($value instanceof Controller) {
                                $value = $value->model();
                            }
                            if ($value instanceof Model) {
                                $val = join_class($value, $item->{$value->_key}, $index);
                                $result .= "<td>{$val}</td>";
                            }
                        } elseif (function_exists($index)) {
                            $result .= "<td>{$index($item->$value)}</td>";
                        } else {
                            $result .= $index($value);
                        }
                    } elseif (is_numeric($index) and is_string($value)) {
                        if (filter_var($item->$value, FILTER_VALIDATE_URL)) {
                            $result .= "<td><a target='_blank' href='{$item->$value}'>{$item->$value}</a></td>";
                        } else {
                            if (strpos($value, 'date') !== false) $item->$value = jdate("Y/m/d", $item->$value);
                            $item->$value = ($item->$value == '' ? '<a class="badge badge-danger p-2 text-white">ثبت نشده</a>' : $item->$value);
                            $result .= "<td>{$item->$value}</td>";
                        }
                    } elseif (is_numeric($index) and is_callable($value)) {
                        $Reflected = new ReflectionFunction($value);
                        if (sizeof($Reflected->getParameters()) > 0) $result .= "<td>{$value($item)}</td>"; else
                            $result .= "<td>{$value()}</td>";
                    } elseif (is_string($index) and is_object($value)) {
                        if ($value instanceof Controller) {
                            $value = $value->model();
                        }
                        if ($value instanceof Model) {
                            $val = join_class($value, $item->{$value->_key}, $index);
                            $result .= "<td>{$val}</td>";
                        }
                    }
                }
                if ($canEdit && $showEdit) {
                    $edit = $this->Html()->editBtn($item);
                }
                if ($canDelete && $showDelete) {
                    $delete = $this->Html()->deleteBtn($item);
                }
                if ($canActivate && $showActive) {
                    $activeOrDeActive = $this->Html()->activeOrDeActive($item);
                }
                if ($showView) {
                    $view = $this->Html()->viewBtn($item);
                }
                $actionBtns = '';
                foreach ($actionBtn as $action) {
                    $actionBtns .= $action($item);
                }
                if ($delete != '' or $edit != '' or $view != '' or $actionBtns != '') {
                    $result .= "<td>$edit $view  $delete $actionBtns</td>";
                }
                if ($activeOrDeActive) $result .= HtmlTags::Td()->Content("$activeOrDeActive");
                $result .= '</tr>';
            }
        }
        return $result;
    }


    public function getThis() {
		return $this->thisView;
	}
	
	public function referrer() {
		return $_REQUEST['fw_referrer'];
	}
	
	public function __destruct() {
	
	}
	
	public function quickAddModals() {
		$output = '';
		foreach ($this->quickAdds as $quickAdd) {
			$output .= $quickAdd;
		}
		return $output;
	}
	
	protected function textField(string $label, $value, int $formGroupSize, bool $editable = true) {
		return HtmlTags::Div(".form-group.col-md-$formGroupSize")->Content(
			HtmlTags::Label()->Content($label),
			HtmlTags::Input('.form-control')->Disabled($editable)->Value("$value")
		);
	}
	
	protected function wrap(TagsClass $Content) {
		return $Content;
	}
	
	
}
