<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class AnnouncementsEntity extends EntityScheme
{
    public $announcement_id;
    /**
     * متن اطلاعیه
     **/
    public $text;
    /**
     * وضعیت اطلاعیه
     **/
    public $image;
    public $status;


    public function model()
    {
        return new \model\Announcements();
    }

    public function apiFormat(): array
    {
        return [
            'id'    => $this->announcement_id,
            'text'  => $this->text,
            'image' => __IMAGES__ . 'Announcements/' . $this->image,
        ];
    }


    protected function dictionary(): array
    {
        return [
            'announcement_id' => 'announcement_id',
            'text'            => 'announcement_text',
            'image'           => 'announcement_image',
            'status'          => 'announcement_status',
        ];
    }
}
