<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class AppVersionEntity extends EntityScheme {
    public $app_version_id;
    /**
     * نسخه ی کنونی
     **/
    public $version_current;
    /**
     * آیا نسخه ی آپدیت اجباری است؟
     **/
    public $version_is_forced_yes_no;
    /**
     * لینک مستقیم
     **/
    public $version_direct_link;
    /**
     * لینک مستقیم موجود است؟
     **/
    public $version_direct_link_yes_no;
    /**
     * لینک گوگل پلی
     **/
    public $version_google_play_link;
    /**
     * لینک گوگل پلی موجود است؟
     **/
    public $version_google_play_link_yes_no;
    /**
     * لینک IApps
     **/
    public $version_iapps_link;
    /**
     * لینک iApps موجود است؟
     **/
    public $version_iapps_yes_no;

    public function model() {
        return new \model\AppVersion();
    }


    protected function dictionary() : array {
        return [
            'app_version_id'                  => 'app_version_id',
            'version_current'                 => 'app_version_current',
            'version_is_forced_yes_no'        => 'app_version_is_forced_yes_no',
            'version_direct_link'             => 'app_version_direct_link',
            'version_direct_link_yes_no'      => 'app_version_direct_link_yes_no',
            'version_google_play_link'        => 'app_version_google_play_link',
            'version_google_play_link_yes_no' => 'app_version_google_play_link_yes_no',
            'version_iapps_link'              => 'app_version_iapps_link',
            'version_iapps_yes_no'            => 'app_version_iapps_yes_no',
        ];
    }

    public function apiFormat() {
        return [
            'current'           => $this->version_current,
            'isForced'          => $this->version_is_forced_yes_no == 1,
            'directLink'        => $this->version_direct_link,
            'hasDirectLink'     => $this->version_direct_link_yes_no == 1,
            'googlePlayLink'    => $this->version_google_play_link,
            'hasGooglePlayLink' => $this->version_google_play_link_yes_no == 1,
            'iAppsLink'         => $this->version_iapps_link,
            'hasIAppsLink'      => $this->version_iapps_yes_no == 1,
        ];
    }
}