<?php

namespace model\Entity;

use FwHtml\FontAwesome;
use FwHtml\Elements\Tags\Option;
use FwHtml\Elements\Tags\Main\HtmlTags;
use DATABASE\ORM\Interact\Entities\EntityScheme;

class FilesEntity extends EntityScheme {
	public $file_id;
	/**
	 * فایل
	 **/
	public $path;
	/**
	 * تاریخ آپلود
	 **/
	public $date;
	public $alt;
	
	public function model() {
		return new \model\Files();
	}
	
	
	protected function dictionary() : array {
		return [
			'file_id' => 'file_id',
			'path'    => 'file_path',
			'date'    => 'file_date',
			'alt'     => 'file_alt',
		];
	}
	
	public function toOption() : Option {
		return HtmlTags::Option()->Value($this->file_id)->Attrs(['img' => htmlentities($this->thumb(), ENT_QUOTES)])->Content($this->alt . ' ' . $this->path);
	}
	
	public function thumb() {
		$path = str($this->path);
		switch (collect($path->explode('.'))->last) {
			case "jpg":
			case "jpeg":
			case "png":
				return HtmlTags::Img()->Attrs(['style' => 'width: 25px;height: 25px;'])->Src(__FILES__ . $this->path);
			case "pdf":
				return HtmlTags::I()->Class(FontAwesome::File_pdf_o());
			case "docs":
				return HtmlTags::I()->Class(FontAwesome::File_word_o());
			case "zip":
			case "rar":
				return HtmlTags::I()->Class(FontAwesome::File_archive_o());
			case "mp3":
			case "wav":
				return HtmlTags::I()->Class(FontAwesome::File_audio_o());
			default:
				return HtmlTags::I()->Class(FontAwesome::File_o());
		}
	}
	
	public function apiFormat() {
		$path = str($this->path);
		switch (collect($path->explode('.'))->last) {
			case "jpg":
			case "jpeg":
			case "png":
				$thumb = __FILES__ . $this->path;
				break;
			case "pdf":
				$thumb = 'FaFilePdf';
				break;
			case "docs":
				$thumb = 'FaFileWord';
				break;
			case "zip":
			case "rar":
				$thumb = 'FaFileArchive';
				break;
			case "mp3":
			case "wav":
				$thumb = 'FaFileAudio';
				break;
			default:
				$thumb = 'FaFile';
				break;
		}
		return [
			'path'  => __FILES__ . $this->path,
			'thumb' => $thumb,
			'alt'   => $this->alt,
			'size'  => number_format(floor(filesize(__SOURCE__ . 'images/Files/' . $this->path) / 1024)),
		];
	}
	
	public function path() {
		return __FILES__ . $this->path;
	}
	
	public function id() {
		return $this->file_id;
	}
	
	public function name() {
		return str($this->alt)->len() > 1 ? $this->alt.'.'.(collect(str($this->path)->explode('.'))->last) : $this->path;
	}
}
