<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class CitiesEntity extends EntityScheme {
    public $city_id;
    /**
     * نام شهر
     **/
    public $name;
    /**
     * انتخاب استان
     **/
    public $state_id;

    public function model() {
        return new \model\Cities();
    }

    public function apiFormat(): array {
        return [
            'id'      => $this->city_id,
            'name'    => $this->name,
            'stateId' => $this->state_id,
        ];
    }


    protected function dictionary(): array {
        return [
            'city_id'  => 'city_id',
            'name'     => 'city_name',
            'state_id' => 'state_id',
        ];
    }
}
