<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Services;

class CategoriesEntity extends EntityScheme {
    public $category_id;
    /**
     * نام دسته بندی
     **/
    public $name;
    public $icon;
    public $view_order;

    public function model(): \model\Categories {
        return new \model\Categories();
    }

    public function apiFormat(): array {
        $services = Services::Db()->where('category_id',$this->category_id)->get()->map(function (ServicesEntity $service){
            return $service->apiFormat();
        });
        return [
            'id'       => $this->category_id,
            'name'     => $this->name,
            'icon'     => __IMAGES__ . 'Categories/' . $this->icon,
            'services' => $services,
        ];
    }


    protected function dictionary(): array {
        return [
            'category_id' => 'category_id',
            'name'        => 'category_name',
            'icon'        => 'category_icon',
            'view_order'  => 'view_order'
        ];
    }
}
