<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\ChatMessages;
use model\Orders;
use model\Users;
use model\UsersTable;

class ChatArchivesEntity extends EntityScheme
{
    public $chat_archive_id;
    public $chat_id;
    /**
     * کاربر
     **/
    public $user_id;
    /**
     * اپراتور
     **/
    public $operator_id;
    /**
     * کاربر
     **/
    public $order_id;
    /**
     * chat_status
     **/
    public $chat_status;
    /**
     * @var \DATABASE\ORM\Interact\Entities\EntityScheme|\DATABASE\ORM\QueryBuilder\DBCollection|\stdClass
     */
    private $_user;
    /**
     * @var \model\Entity\ChatMessagesEntity
     */
    private $_lastMessage;

    public function model()
    {
        return new \model\ChatArchives();
    }

    public function user(): ?UsersEntity
    {
        if (!($this->_user instanceof UsersEntity)) {
            $this->_user = Users::get($this->user_id);
        }
        return $this->_user;
    }

    public function lastMessage(): ?ChatMessagesEntity
    {
        $message = ChatMessages::Db()->where('chat_id', $this->chat_id)->orderBy('chat_message_id', true)->limit(1)->get()->first;
        if ($message instanceof ChatMessagesEntity) {
            $this->_lastMessage = $message;
        }
        return $this->_lastMessage;
    }

    public function unreadCount(): int
    {
        return ChatMessages::Db()->where('chat_id', $this->chat_id)->where('message_read', 0)->rowCount();
    }

    public function apiFormat(?UsersEntity $user = null): array
    {
        /** @var OrdersEntity $order */
        $order = Orders::get($this->order_id);
        $operator = UsersTable::get($this->operator_id);
        return [
            'id' => $this->chat_id,
            'operator' => $this->operator_id,
            'operatorData' => $operator instanceof UsersTableEntity
                ? $operator->apiFormat()
                : [
                    'id' => $this->operator_id,
                    'name' => "اپراتور شماره $this->operator_id",
                    'image' => __IMAGES__ . 'Users/placeholder.jpg',
                ],
            'order' => $order->apiFormat(),
            'isClosed' => $this->chat_status == 2,
            'isArchived' => true,
            'messages' => $user instanceof UsersEntity ? ChatMessages::Db()->where('chat_id', $this->chat_id)->get()->map(function (ChatMessagesEntity $chatMessage) use ($user) {
                return $chatMessage->apiFormat($user);
            })->values()->all() : [],
        ];
    }

    protected function dictionary(): array
    {
        return [
            'chat_id' => 'chat_id',
            'chat_archive_id' => 'chat_archive_id',
            'user_id' => 'user_id',
            'operator_id' => 'operator_id',
            'order_id' => 'order_id',
            'chat_status' => 'chat_status',
        ];
    }
}
