<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use model\Categories;
use model\ChatArchives;
use model\Chats;
use model\Services;

class OrdersEntity extends EntityScheme
{
    public $order_id;
    public $user_id;
    public $category_id;
    public $service_id;
    public $service_form;
    public $user_table_id;
    public $order_date;
    public $order_price;
    public $order_status;

    public function model(): \model\Orders
    {
        return new \model\Orders();
    }

    public function apiFormat(): array
    {
        /** @var ServicesEntity $service */
        $service = Services::get($this->service_id);
        /** @var CategoriesEntity $category */
        $category = Categories::get($service->category_id);
        $chat = Chats::getOneFiltered('order_id', $this->order_id);
        $chatArchive = ChatArchives::getOneFiltered('order_id', $this->order_id);
        return [
            'id' => $this->order_id,
            'unreadCount' => ($chat instanceof ChatsEntity ? $chat->unreadCount('operator') : 0),
            'chatId' => ($chat instanceof ChatsEntity ? $chat->chat_id : ($chatArchive instanceof ChatArchivesEntity ? $chatArchive->chat_id : 0)),
            'lastMessageDate' => ($chat instanceof ChatsEntity ? strtotime($chat->lastMessage()->created_at) : ($chatArchive instanceof ChatArchivesEntity ? strtotime($chatArchive->lastMessage()->created_at) : 0)),
            'category' => $category->apiFormat(),
            'service' => $service->apiFormat(),
            'date' => jdate("Y/m/d", $this->order_date),
            'orderDate' => $this->order_date,
            'price' => (int)$this->order_price,
            'status' => [
                'id' => (int)$this->order_status,
                'name' => $this->getStatus(),
            ],
        ];
    }

    private function getStatus(): string
    {
        switch ($this->order_status) {
            case "0":
                return "در حال بررسی";
            case "1":
                return "انجام شده";
            case "2":
                return "در انتظار پرداخت";
            case "3":
                return "در حال انجام";
            case "4":
                return "منقضی شده";
            case "5":
                return "عدم تایید";
        }
        return "";
    }

    protected function dictionary(): array
    {
        return [
            'order_id' => 'order_id',
            'user_id' => 'user_id',
            'category_id' => 'category_id',
            'service_id' => 'service_id',
            'service_form' => 'service_form',
            'user_table_id' => 'user_table_id',
            'order_date' => 'order_date',
            'order_price' => 'order_price',
            'order_status' => 'order_status',
        ];
    }
}
