<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class ServicesEntity extends EntityScheme {
    public $service_id;
    /**
     * خدمات
     **/
    public $name;
    public $icon;
    /**
     * انتخاب دسته بندی
     **/
    public $category_id;
    public $service_video;

    public function model(): \model\Services {
        return new \model\Services();
    }

    public function apiFormat(): array {
        return [
            'id'   => $this->service_id,
            'name' => $this->name,
            'icon' => __IMAGES__ . 'Services/' . $this->icon,
        ];
    }

    public function singleFormat(): array {
        return [
            'hasVideo' => is_file(__SOURCE__ . 'images/Services/' . $this->service_video),
            'video'    => is_file(__SOURCE__ . 'images/Services/' . $this->service_video) ? __IMAGES__ . 'Services/' . $this->service_video : null,
            'id'       => $this->service_id,
            'name'     => $this->name,
            'icon'     => __IMAGES__ . 'Services/' . $this->icon,
            'fields'   => $this->getForm(),
        ];
    }

    private function getForm(): array {
        $form = json_decode($this->service_form, true);
        if (!is_array($form)) {
            return [];
        }
        $output = [];
        foreach ($form as $key => $item) {
            $item['key'] = $key;
            $item['type'] = $item['type'] ?? 'input';
            $output[] = $item;
        }
        return $output;
    }

    protected function dictionary(): array {
        return [
            'service_id'    => 'service_id',
            'name'          => 'service_name',
            'icon'          => 'service_icon',
            'category_id'   => 'category_id',
            'service_video' => 'service_video',
        ];
    }
}
