<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class TopSlidersEntity extends EntityScheme {
    public $top_slider_id;
    /**
     * بنر
     **/
    public $slider_image;
    public $view_order;
    public $link;

    public function model() {
        return new \model\TopSliders();
    }

    public function sortName() {
        return "<img src='https://internetcafe.parsa.today/admin/src/images/TopSliders/$this->slider_image' width='150' height='150'>";
    }


    public function apiFormat(): array {
        return [
            'id'    => $this->top_slider_id,
            'link'  => $this->link,
            'image' => __IMAGES__ . 'TopSliders/' . $this->slider_image,
        ];
    }

    protected function dictionary(): array {
        return [
            'top_slider_id' => 'top_slider_id',
            'slider_image'  => 'top_slider_image',
            'view_order'    => 'view_order',
            'link'          => 'top_slider_link'
        ];
    }
}
