<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class NotificationsEntity extends EntityScheme
{
    public $notification_id;
    /**
     * کاربر
     **/
    public $user_id;
    /**
     * توکن
     **/
    public $token;
    /**
     * تیتر
     **/
    public $title;
    /**
     * متن
     **/
    public $body;
    /**
     * بدنه
     **/
    public $data;
    public $type;

    public function model()
    {
        return new \model\Notifications();
    }

    public function apiFormat(): array
    {
        return [
            'id' => $this->notification_id,
            'userId' => $this->user_id,
            'token' => $this->token,
            'title' => $this->title,
            'body' => $this->body,
            'type' => $this->type,
            'data' => json_decode($this->data),
            'createdAt' => strtotime($this->created_at) * 1000,
        ];
    }


    protected function dictionary(): array
    {
        return [
            'notification_id' => 'notification_id',
            'user_id' => 'user_id',
            'token' => 'notification_token',
            'title' => 'notification_title',
            'body' => 'notification_body',
            'type' => 'notification_type',
            'data' => 'notification_data',
        ];
    }
}
