<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;

class TransactionsEntity extends EntityScheme {
    public $transaction_id;
    /**
     * نوع تراکنش
     **/
    public $type;
    /**
     * مبلغ
     **/
    public $amount;
    /**
     * کسر شده
     **/
    public $pay_yes_no;
    /**
     * کاربر
     **/
    public $user_id;

    public function model() {
        return new \model\Transactions();
    }

    public function apiFormat(): array {
        return [
            'id'         => $this->transaction_id,
            'type'       => $this->type,
            'amount'     => $this->amount,
            'isPayed'    => $this->pay_yes_no == 1,
            'createdAt' => strtotime($this->created_at),
        ];
    }


    protected function dictionary(): array {
        return [
            'transaction_id' => 'transaction_id',
            'type'           => 'transaction_type',
            'amount'         => 'transaction_amount',
            'pay_yes_no'     => 'transaction_pay_yes_no',
            'user_id'        => 'user_id',
        ];
    }
}
