<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;
use model\Ads;
use model\Announcements;
use model\Chats;
use model\Notifications;
use model\Orders;
use model\Users;

class UsersEntity extends EntityScheme
{
    public $user_id;
    /**
     * نام
     **/
    public $firstname;
    /**
     * نام خانوادگی
     **/
    public $lastname;
    /**
     * رمز عبور
     **/
    public $mobile;
    /**
     * توکن
     **/
    public $token;
    /**
     * تایخ ثبت نام
     **/
    public $register_date;
    /**
     * تاریخ آخرین لاگین
     **/
    public $login_date;

    public $avatar;
    public $state_id;
    public $city_id;
    public $credit;
    public $last_seen_date;
    /**
     * @var void
     */
    public $firebase_token;
    public $register;
    /**
     * @var void
     */
    public $user_announcements;

    public function model(): \model\Users
    {
        return new \model\Users();
    }

    public function apiFormat(): array
    {
        $chats = Orders::Db()->whereIn('order_status', [
            2,
            3,
            0
        ])->where('user_id', $this->user_id)->get()->map(function (OrdersEntity $ordersEntity) {
            return Chats::getOneFiltered('order_id', $ordersEntity->order_id)->chat_id;
        })->filter(function ($id) {
            return $id > 0;
        });
        $notificationCount = Notifications::Db()->where('user_id', $this->user_id)->where('created_at', '>', date("Y-m-d H:i:s", $this->last_seen_date))->rowCount();
        $userAnnouncements = json_decode($this->user_announcements, true);
        $announcements = Announcements::Db();
//        if (count($userAnnouncements) > 0) {
//            $announcements = $announcements->whereNotIn('announcement_id', $userAnnouncements);
//        }
        $announcements = $announcements->where('announcement_active', '1')->get()->map(function (AnnouncementsEntity $announcement) use ($userAnnouncements) {
            return $announcement->apiFormat();
        })->values();
        $userAnnouncements = array_merge($userAnnouncements, collect($announcements->all())->map(function ($item) {
            return $item['id'];
        })->values()->all());
        Users::edit($this->user_id, [
            'user_announcements' => json_encode($userAnnouncements),
        ]);
        return [
            'id'                => $this->user_id,
            'firstName'         => $this->firstname . '',
            'lastName'          => $this->lastname . '',
            'fullName'          => $this->firstname . ' ' . $this->lastname,
            'stateId'           => $this->state_id,
            'cityId'            => $this->city_id,
            'mobile'            => $this->mobile,
            'avatar'            => is_file(__SOURCE__ . 'images/Users/' . $this->user_id . '.jpg') ? __IMAGES__ . '/Users/' . $this->user_id . '.jpg' : __IMAGES__ . '/Users/placeholder.jpg',
            'credit'            => $this->credit,
            'birthdate'         => fa_to_en(jdate("Y/m/d", $this->birthdate)),
            'chats'             => $chats->values()->all(),
            'notificationCount' => $notificationCount,
            'announcements'     => $announcements,
            'plateTypes'        => [
                "ب",
                "ج",
                "د",
                "س",
                "الف",
                "ت",
                "ژ",
                "ع",
                "گ",
                "D",
                "S",
                "ک",
                "ص",
                "ط",
                "ق",
                "ل",
                "م",
                "ن",
                'و',
                "هـ",
                "ی",
            ],
        ];
    }

    public function image()
    {
        return is_file(__SOURCE__ . 'images/Users/' . $this->user_id . '.jpg') ? __IMAGES__ . '/Users/' . $this->user_id . '.jpg' : __IMAGES__ . '/Users/placeholder.jpg';
    }

    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->user_id)->Content($this->firstname . ' ' . $this->lastname . ' (' . $this->mobile . ')');
    }

    protected function dictionary(): array
    {
        return [
            'user_id'            => 'user_id',
            'firstname'          => 'user_firstname',
            'lastname'           => 'user_lastname',
            'mobile'             => 'user_mobile',
            'avatar'             => 'user_avatar',
            'register_date'      => 'created_at',
            'state_id'           => 'state_id',
            'city_id'            => 'city_id',
            'credit'             => 'user_credit',
            'firebase_token'     => 'firebase_token',
            'user_announcements' => 'user_announcements',
            'register'           => 'register',
        ];
    }
}
