<?php

namespace model\Entity;

use DATABASE\ORM\Interact\Entities\EntityScheme;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\Elements\Tags\Option;

class UsersTableEntity extends EntityScheme
{
    public $user_id;
    public $user_username;
    public $user_password;
    public $supervisor_id;
    public $branch_id;
    public $user_profile;
    public $user_name;
    public $user_email;
    public $role_name;
    public $state_ids;
    public $city_ids;
    public $service_ids;
    public $user_credit_card;
    public $user_card_name;
    public $percentage_share;
    public $user_nameToKnow;
    public $user_last_pass_1;
    public $user_last_pass_2;
    public $tmp_hash;
    public $user_status;


    public function model()
    {
        return new \model\UsersTable();
    }

    public function apiFormat(): array
    {
        return [
            'id' => $this->user_id,
            'name' => $this->user_nameToKnow ?? $this->user_name,
            'image' => is_file(__SOURCE__.'images/UsersTable/'.$this->user_profile) ? __IMAGES__.'UsersTable/'.$this->user_profile : __IMAGES__ . 'Users/placeholder.jpg',
        ];
    }


    public function toOption(): Option
    {
        return HtmlTags::Option()->Value($this->user_id)->Content(
            $this->user_name . " - شماره $this->user_id - ($this->user_username)"
        );
    }

    protected function dictionary(): array
    {
        return [
            'user_id' => 'user_id',
            'user_username' => 'user_username',
            'user_password' => 'user_password',
            'supervisor_id' => 'supervisor_id',
            'branch_id' => 'branch_id',
            'user_profile' => 'user_profile',
            'user_name' => 'user_name',
            'user_email' => 'user_email',
            'role_name' => 'role_name',
            'state_ids' => 'state_ids',
            'city_ids' => 'city_ids',
            'service_ids' => 'service_ids',
            'user_credit_card' => 'user_credit_card',
            'user_card_name' => 'user_card_name',
            'percentage_share' => 'percentage_share',
            'user_nameToKnow' => 'user_nameToKnow',
            'user_last_pass_1' => 'user_last_pass_1',
            'user_last_pass_2' => 'user_last_pass_2',
            'tmp_hash' => 'tmp_hash',
            'user_status' => 'user_status',
        ];
    }
}
