<?php
$operatorStatus = \model\UsersTable::get(\FwAuthSystem\Main\UserObject::instance()->getUserId())->user_status;
?>
<div class="content-header">
    <div class="container-fluid">
        <div class="row mb-2">
            <div class="col-sm-6 d-flex">
                <h1 class="m-0 text-dark">خوش آمدید! </h1>
            </div>
            <div class="col-sm-6">
                <ol class="breadcrumb float-sm-left">
                    <li class="breadcrumb-item"><a href="#">خانه</a></li>
                    <li class="breadcrumb-item active">داشبورد مدیریتی</li>
                </ol>
            </div>
        </div>
        <div class="row mt-5 mb-3">
            <div class="col-sm-6 d-flex">
                <h4 class="m-0 text-dark">آمار امروز:</h4>
            </div>
        </div>

        <div class="row">
            <?php

            use FwHtml\Elements\Tags\Main\HtmlTags;
            function addCard(string $showNumber, string $nameFiled, string $link, string $id, string $color) {
                echo HtmlTags::Div('.col-lg-3.col-6')->Content(
                    HtmlTags::Div('.small-box.' . $color . '')->Content(
                        HtmlTags::Div('.inner.text-center')->Content(
                            HtmlTags::H3($showNumber),
                            HtmlTags::P($nameFiled)
                        ),
                        HtmlTags::A('.small-box-footer.ajax')->Rel($link)->Content(
                            'اطلاعات بیشتر',
                            HtmlTags::I('.fa.fa-arrow-circle-left.mr-1')
                        )->Id($id)
                    )
                );
            }
            $lastWeek = strtotime("-1 week");
            $today = strtotime("today");
            $tomorrow = strtotime("tomorrow");
            $lastMonth = strtotime("-1 month");


            $role = \FwAuthSystem\Main\UserObject::instance()->getRole();
            if ($role == "AdminRole" || $role == 'SupervisorRole'){
                $todayPayments = \model\PaymentTable::getAllConditioned("payment_date > $today AND payment_date < $tomorrow AND payment_status = 1");
                $todayAmount = 0;
                foreach ($todayPayments as $todayPayment){
                    $todayAmount += $todayPayment->payment_amount;
                }

                $lastWeekPayments = \model\PaymentTable::getAllConditioned("payment_date > $lastWeek AND payment_date < $today AND payment_status = 1");
                $lastWeekAmount = 0;
                foreach ($lastWeekPayments as $lastWeekPayment){
                    $lastWeekAmount += $lastWeekPayment->payment_amount;
                }

                $lastMonthPayments = \model\PaymentTable::getAllConditioned("payment_date > $lastMonth AND payment_date < $today AND payment_status = 1");
                $lastMonthAmount = 0;
                foreach ($lastMonthPayments as $lastMonthPayment){
                    $lastMonthAmount += $lastMonthPayment->payment_amount;
                }
            }else{
                $operatorId = \FwAuthSystem\Main\UserObject::instance()->getUserId();
                $todayPayments = \model\PaymentTable::getAllConditioned("payment_date > $today AND payment_date < $tomorrow AND payment_status = 1 AND user_table_id = $operatorId");
                $todayAmount = 0;
                foreach ($todayPayments as $todayPayment){
                    $todayAmount += $todayPayment->payment_amount;
                }

                $lastWeekPayments = \model\PaymentTable::getAllConditioned("payment_date > $lastWeek AND payment_date < $today AND payment_status = 1 AND user_table_id = $operatorId");
                $lastWeekAmount = 0;
                foreach ($lastWeekPayments as $lastWeekPayment){
                    $lastWeekAmount += $lastWeekPayment->payment_amount;
                }

                $lastMonthPayments = \model\PaymentTable::getAllConditioned("payment_date > $lastMonth AND payment_date < $today AND payment_status = 1 AND user_table_id = $operatorId");
                $lastMonthAmount = 0;
                foreach ($lastMonthPayments as $lastMonthPayment){
                    $lastMonthAmount += $lastMonthPayment->payment_amount;
                }
            }





            addCard(\model\Users::Db()->rowCount(), 'کل کاربران', '', '', 'bg-success');
            addCard(\model\Users::Db()->where("register",strtotime('today'))->rowCount(), 'ثبت نام جدید (امروز)', '', '', 'bg-success');
            addCard(count(\model\UsersTable::getAllFiltered('role_name',"SupervisorRole")), 'تعداد سوپروایزر های مجموعه', '', '', 'bg-success');
            addCard(count(\model\UsersTable::getAllFiltered('role_name',"OperatorRole")) , 'تعداد اپراتور های مجموعه', '', '', 'bg-success');
            addCard(0, 'بازدید های امروز اپ', '', '', 'bg-success');
            addCard(price_format_rial($todayAmount), 'مجموع پرداخت های امروز', '', '', 'bg-success');
            addCard(price_format_rial($lastWeekAmount) , 'مجموعه درامد هفته گذشته', '', '', 'bg-success');
            addCard(price_format_rial($lastMonthAmount) , 'مجموعه درامد ماه گذشته', '', '', 'bg-success');

            ?>
        </div>
        <div class="row">
            <div class="col-md-6">
                <!-- AREA CHART -->
                <div class="card card-primary card-outline  card-outline">
                    <div class="card-header">
                        <h3 class="card-title small">تفکیک ثبت نام ها</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="chart">
                            <canvas id="areaChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- DONUT CHART -->
                <div class="card card-danger  card-outline">
                    <div class="card-header">
                        <h3 class="card-title small">بازدید ها</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="donutChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- PIE CHART -->
                <div class="card card-warning  card-outline">
                    <div class="card-header">
                        <h3 class="card-title small">دقایق سپری شده</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <div class="card-body">
                        <canvas id="pieChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

            </div>
            <!-- /.col (LEFT) -->
            <div class="col-md-6">
                <!-- LINE CHART -->
                <div class="card card-info  card-outline">
                    <div class="card-header">
                        <h3 class="card-title small">نمودار خطی</h3>
                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="chart">
                            <canvas id="lineChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- BAR CHART -->
                <div class="card card-danger  card-outline">
                    <div class="card-header">
                        <h3 class="card-title small">نمودار ستونی</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="chart">
                            <canvas id="barChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

                <!-- STACKED BAR CHART -->
                <div class="card card-success  card-outline">
                    <div class="card-header">
                        <h3 class="card-title small">نمودار چند ستونی</h3>

                        <div class="card-tools">
                            <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fa fa-minus"></i>
                            </button>
                            <button type="button" class="btn btn-tool" data-card-widget="remove"><i class="fa fa-times"></i></button>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="chart">
                            <canvas id="stackedBarChart" style="min-height: 250px; height: 250px; max-height: 250px; max-width: 100%;"></canvas>
                        </div>
                    </div>
                    <!-- /.card-body -->
                </div>
                <!-- /.card -->

            </div>
            <!-- /.col (RIGHT) -->
        </div>
    </div>
</div>

