<?php

use FwHtml\FontAwesome as Fa;

$SideBar = new Sidebar(true);


$SideBar->Item("مدیریت سیستم", Fa::Wrench())->_items([
//    MenuItem::create("فایل منیجر", Fa::Stack_exchange())->LinksTo(\controller\Files::class),
    MenuItem::create("بنر های تبلیغاتی", Fa::Sliders())->LinksTo(\controller\TopSliders::class),
    MenuItem::create("ورژن اپلیکیشن", Fa::Mobile())->LinksTo(\controller\AppVersion::class),
    MenuItem::create("اطلاعیه ها", Fa::Envelope_o())->LinksTo(\controller\Announcements::class),
    MenuItem::create("تنظیمات", Fa::Wrench())->LinksTo(\controller\Settings::class),
]);
$SideBar->Item("اس ام اس", Fa::Internet_explorer())->_items([
    MenuItem::create("ارسال پیامک گروهی", Fa::Envelope_open_o())->LinksTo(\controller\SmsGroups::class),
    MenuItem::create("پیام های آماده", Fa::Envelope())->LinksTo(\controller\PreparedMessages::class),
//    MenuItem::create("انواع اس ام اس", Fa::Envelope_square())->LinksTo(\controller\SmsTypes::class),
]);
$SideBar->Item("چت", Fa::Envelope_open())->_items([
    MenuItem::create("آرشیو", Fa::Archive())->LinksTo(\controller\Chats::RelPath([],'archivedChats')),
    MenuItem::create("چت", Fa::Envelope())->LinksTo(\controller\Chats::class),
]);
$SideBar->Item("گزارشات", Fa::Newspaper_o())->_items([
//    MenuItem::create("فاکتور ها", Fa::Newspaper_o())->LinksTo(\controller\SmsTypes::class),
//    MenuItem::create("گزارشات تراکنش های کاربران", Fa::Newspaper_o())->LinksTo(\controller\PaymentTable::class),
    MenuItem::create("گزارش تراکنش های کاربران", Fa::Users())->LinksTo(\controller\SaleReports::class),
    MenuItem::create("گزارش فعالیت اپراتور ها", Fa::User_secret())->LinksTo(\controller\OperatorReports::class),
]);
$SideBar->Item("وبلاگ", Fa::Internet_explorer())->_items([
    MenuItem::create("پست ها", Fa::Internet_explorer())->LinksTo(\controller\Blogs::class),
]);
$SideBar->Item("استارت آپ اپلیکیشن", Fa::Mobile())->_items([
    MenuItem::create("قوانین", Fa::Gavel())->LinksTo(\controller\Rules::class),
    MenuItem::create("ویدیو آموزشی", Fa::Video_camera())->LinksTo(\controller\AppVideos::class),
]);

$SideBar->Item("اطلاعات جغرافیایی", Fa::Info_circle())->_items([
    MenuItem::create("مدیریت استان ها", Fa::Location_arrow())->LinksTo(\controller\States::class),
    MenuItem::create("مدیریت شهر ها", Fa::Location_arrow())->LinksTo(\controller\Cities::class),
    //    MenuItem::create("مدیریت مناطق",Fa::Location_arrow())->LinksTo(\controller\Districts::class),
]);

$SideBar->Item("مدیریت کاربران", Fa::User())->_items([
    MenuItem::create("کاربران", Fa::User_plus())->LinksTo(\controller\Users::class),
    MenuItem::create("اطلاعات تکمیلی کاربران", Fa::User_plus())->LinksTo(\controller\Individuals::class),
    MenuItem::create("یادآورها", Fa::Clock_o())->LinksTo(\controller\Reminders::class),
    MenuItem::create("کاربران پنل", Fa::User_plus())->LinksTo(\controller\UsersTable::class),
]);

if (\FwAuthSystem\Main\UserObject::instance()->getRole()=="AdminRole"){
    $SideBar->Item("مدیریت سفارشات", Fa::First_order())->_items([
        MenuItem::create("مدیریت سفارشات", Fa::Plus_circle())->LinksTo(\controller\Orders::class),
        MenuItem::create("سفارشات در انتظار تایید", Fa::Question())->LinksTo(\controller\Orders::RelPath(['order_status' => '0'], 'main')),
        MenuItem::create("سفارشات انجام شده", Fa::Check())->LinksTo(\controller\Orders::RelPath(['order_status' => '1'], 'main')),
        MenuItem::create("سفارشات در انتظار پرداخت", Fa::Question_circle())->LinksTo(\controller\Orders::RelPath(['order_status' => '2'], 'main')),
        MenuItem::create("سفارشات در حال انجام", Fa::Upload())->LinksTo(\controller\Orders::RelPath(['order_status' => '3'], 'main')),
        MenuItem::create("سفارشات منقضی شده", Fa::Clock_o())->LinksTo(\controller\Orders::RelPath(['order_status' => '4'], 'main')),
        MenuItem::create("سفارشات رد شده", Fa::Times())->LinksTo(\controller\Orders::RelPath(['order_status' => '5'], 'main')),
        MenuItem::create("سفارشات بدون اپراتور", Fa::Times())->LinksTo(\controller\Orders::RelPath([], 'noOperatorOrders')),
    ]);
}elseif (\FwAuthSystem\Main\UserObject::instance()->getRole()=="SupervisorRole"){
    $SideBar->Item("مدیریت سفارشات", Fa::First_order())->_items([
        MenuItem::create("مدیریت سفارشات", Fa::Plus_circle())->LinksTo(\controller\Orders::RelPath([],'supervisorMain')),
        MenuItem::create("سفارشات در انتظار تایید", Fa::Question())->LinksTo(\controller\Orders::RelPath(['order_status' => '0'], 'supervisorMain')),
        MenuItem::create("سفارشات انجام شده", Fa::Check())->LinksTo(\controller\Orders::RelPath(['order_status' => '1'], 'supervisorMain')),
        MenuItem::create("سفارشات در انتظار پرداخت", Fa::Question_circle())->LinksTo(\controller\Orders::RelPath(['order_status' => '2'], 'supervisorMain')),
        MenuItem::create("سفارشات در حال انجام", Fa::Upload())->LinksTo(\controller\Orders::RelPath(['order_status' => '3'], 'supervisorMain')),
        MenuItem::create("سفارشات منقضی شده", Fa::Clock_o())->LinksTo(\controller\Orders::RelPath(['order_status' => '4'], 'supervisorMain')),
        MenuItem::create("سفارشات رد شده", Fa::Times())->LinksTo(\controller\Orders::RelPath(['order_status' => '5'], 'supervisorMain')),
        MenuItem::create("سفارشات بدون اپراتور", Fa::Times())->LinksTo(\controller\Orders::RelPath([], 'noOperatorOrders')),
    ]);
} else{
    $id = \FwAuthSystem\Main\UserObject::instance()->getUserId();
    $SideBar->Item("مدیریت سفارشات", Fa::First_order())->_items([
        MenuItem::create("مدیریت سفارشات", Fa::Plus_circle())->LinksTo(\controller\Orders::RelPath(['user_table_id' => $id])),
        MenuItem::create("سفارشات در انتظار تایید", Fa::Question())->LinksTo(\controller\Orders::RelPath(['order_status' => '0','user_table_id' => $id], 'main')),
        MenuItem::create("سفارشات انجام شده", Fa::Check())->LinksTo(\controller\Orders::RelPath(['order_status' => '1','user_table_id' => $id], 'main')),
        MenuItem::create("سفارشات در انتظار پرداخت", Fa::Question_circle())->LinksTo(\controller\Orders::RelPath(['order_status' => '2','user_table_id' => $id], 'main')),
        MenuItem::create("سفارشات در حال انجام", Fa::Upload())->LinksTo(\controller\Orders::RelPath(['order_status' => '3','user_table_id' => $id], 'main')),
        MenuItem::create("سفارشات منقضی شده", Fa::Clock_o())->LinksTo(\controller\Orders::RelPath(['order_status' => '4','user_table_id' => $id], 'main')),
        MenuItem::create("سفارشات رد شده", Fa::Times())->LinksTo(\controller\Orders::RelPath(['order_status' => '5','user_table_id' => $id], 'main')),
    ]);
}



$SideBar->Item("مدیریت دسته بندی ها", Fa::Mobile())->_items([
    MenuItem::create("دسته بندی", Fa::List_ol())->LinksTo(\controller\Categories::class),
    MenuItem::create("خدمات", Fa::Spotify())->LinksTo(\controller\Services::class),
    MenuItem::create("تگ های جستجو", Fa::Tags())->LinksTo(\controller\SearchTags::class),
]);


//$SideBar->Item('Tools', Fa::Wrench())->_items([
//    MenuItem::create('QUERY BUILDER', Fa::Times_circle_o())
//        ->LinksTo('QueryBuilder/QueryBuilder.fwTools'),
//    MenuItem::create('MODEL GENERATOR', Fa::Times_circle_o())
//        ->LinksTo('modelGenerator/modelGenerator.fwTools'),
//    MenuItem::create('Form Generator', Fa::Times_circle_o())
//        ->LinksTo('formGenerator/formGenerator.fwTools'),
//    MenuItem::create('Data seeder', Fa::Times_circle_o())
//        ->LinksTo('DataSeeder/DataSeeder.fwTools'),
//]);
$SideBar->render();
