<?php

use controller\Orders;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;

$operator_id = \FwAuthSystem\Main\UserObject::instance()->getUserId();
$role = \FwAuthSystem\Main\UserObject::instance()->getRole();
$userStatus = \model\UsersTable::get($operator_id)->user_status;
if ($role == "OperatorRole") {
    $orderCount = \model\Orders::Db()->where("user_table_id", $operator_id)->rowCount();
    if ($userStatus == 1) {
        $deactive = HtmlTags::Button('.btn.btn-outline-danger.m-2.p-2.m-1.deactiveOperator')->Content(
            "غیر فعال سازی اکانت"
        )->Data_('id', $operator_id);
    } else {
        $deactive = HtmlTags::Button('.btn.btn-outline-success.m-2.p-2.m-1.activeOperator')->Content(
            "فعال سازی اکانت"
        )->Data_('id', $operator_id);
    }

} else {
    $orderCount = \model\Orders::Db()->rowCount();
    $deactive = '';
}

?>


<?php
if ($userStatus == 0) {
    $deActiveMessage = "<div class='p-3 mb-2 mr-auto bg-danger text-white rounded'>اکانت شما غیر فعال است و شما قادر به دریافت سفارش نیستید</div>";
} else {
    $deActiveMessage = '';
}
?>

<?= $deActiveMessage ?>


<div>
    <?= $deactive ?>
</div>


<li class="nav-item dropdown show">
    <a class="nav-link" data-toggle="dropdown" href="#" aria-expanded="true">
        <i class="far fa fa-bell"> ll </i>
        <span class="badge badge-warning navbar-badge"><?= $orderCount ?></span>
    </a>
    <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right" style="right: inherit; left: 0px;">

        <span class="dropdown-item dropdown-header"><?= $orderCount ?> اعلان</span>
        <div class="dropdown-divider"></div>
        <?=
        HtmlTags::A('.dropdown-item.ajax')->Rel(Orders::RelPath(['user_table_id' => \FwAuthSystem\Main\UserObject::instance()->getUserId()]))->Href("#")->Content(
            HtmlTags::I('.mr-2.ml-2')->Class(FontAwesome::Envelope()),
            "سفارشات",
            HtmlTags::Span(".float-left.text-muted.text-sm")->Content(
                $orderCount . ''
            )
        )
        ?>

        <!--        <div class="dropdown-divider"></div>-->
        <!--        <a href="#" class="dropdown-item">-->
        <!--            <i class="fas fa fa-users mr-2"></i> 8 درخواست دوستی-->
        <!--            <span class="float-left text-muted text-sm">12 ساعت</span>-->
        <!--        </a>-->

        <!--        <div class="dropdown-divider"></div>-->
        <!--        <a href="#" class="dropdown-item">-->
        <!--            <i class="fas fa fa-file mr-2"></i> 3 گزارش جدید-->
        <!--            <span class="float-left text-muted text-sm">2 روز</span>-->
        <!--        </a>-->

        <div class="dropdown-divider"></div>
        <a href="#" class="dropdown-item dropdown-footer">نمایش تمام اعلان ها</a>
    </div>
</li>


<li class="dropdown">
    <a href="#" class="nav-link dropdown-toggle" id="navbarDropdown" data-toggle="dropdown" aria-expanded="false">
        <?= $Admin->getName() ?> <b class="caret"></b>
    </a>
    <div class="dropdown-menu user-panel dropdown-menu-right">
        <a class="dropdown-item ajax" rel="EditProfile.php">ویرایش پروفایل</a>
        <div class="dropdown-divider"></div>
        <a class="dropdown-item ajax" rel="sortSideBar">چینش منوی راست</a>
        <div class="dropdown-divider"></div>
        <a class="dropdown-item" href="https://internetcafe.parsa.today/admin/login">خروج</a>
    </div>
</li>

