<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class FirstCategoriesMigration extends Migratable {
    const modelName = 'FirstCategories';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('first_categorie_id');
			$blueprint->VarChar('first_category_name')->Len(150);
			$blueprint->VarChar('first_category_icon')->Len(150);
			$blueprint->Text('created_at');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
