<?php

namespace FwMigrationSystem\User;

use FwMigrationSystem\Main\Migratable;
use FwMigrationSystem\Main\Migration;
use FwMigrationSystem\Resources\Blueprint;
use FwMigrationSystem\Resources\TableName;

class ChatArchivesMigration extends Migratable {
    const modelName = 'ChatArchives';

    public function create_table() {
        return Migration::Create(new TableName(self::modelName), function (Blueprint $blueprint) {
            $blueprint->primary_key('chat_archive_id');
			$blueprint->Int('user_id')->Len(150);
			$blueprint->Int('operator_id')->Len(150);
			$blueprint->Int('order_id')->Len(150);
			$blueprint->Int('وضغیت')->Len(150);
			$blueprint->Datetime('created_at')->Default('CURRENT_TIMESTAMP()');

             return $blueprint;
        });
    }

    public function drop_table() {
        return Migration::DropIfExists(new TableName(self::modelName));
    }
}
