<?php

namespace model;

use fwJson\Json;
use DATABASE\Model;
use PaymentInterface;
use payment\helpers\ParsianPaymentHelpers;

class  PaymentTable extends Model implements PaymentInterface {
	public $_table = 'PaymentTable';
	public $_key = 'payment_id';
    public static array $types = [
        'buyPlan' => "خرید اشتراک",
        'charge'  => "شارژ کیف پول",
    ];
	public static function toDataModel($item) {
		$PaymentHelpers = new ParsianPaymentHelpers();
		return [
			'type'        => $PaymentHelpers->getType($item->payment_type),
			'gate'        => $item->payment_gate,
			'date'        => jdate("Y/m/d", strtotime($item->payment_sdate)),
			'hour'        => jdate("H:i", strtotime($item->payment_sdate)),
			'isSucceeded' => $item->payment_status == 1,
			'amount'      => $item->payment_amount / 10,
			'code'        => $item->payment_resnum,
			'refnum'      => $item->payment_refnum,
		];
	}

    public static function getType($payment_type) {
        return self::$types[$payment_type] ?? "نا مشخص";
    }
	public function save(int $customer_id, int $total_amount, string $resNum, Json $orderData, string $type, string $gate = 'زرین پال') : bool {
		if ($id = $this::add([
			'user_id'        => $customer_id,
			'payment_amount'     => $total_amount,
			$this->ResNumField() => $resNum,
			'payment_date'       => time(),
			'payment_type'       => $type,
			'payment_gate'       => $gate,
			'payment_data'       => $orderData->jsonSerialize(),
//			'payment_from'       => str("{$_SERVER['HTTP_REFERER']}")->includes('negaclub.ir') ? "site" : "app",
		])) {
			if ($type == 'credit_pay') {
				// پرداخت برای اعتبار
				// todo در جدول transactionHistory ثبت شود.
				return true;
			} else {
				// پرداخت فروشگاه
			}
		}
		return false;
	}

	public function ResNumField() : string {
		return 'payment_resnum';
	}

	public function RefNumField() : string {
		return 'payment_refnum';
	}
}
