<?php

namespace model;

use DATABASE\Model;
use model\Entity\UsersEntity;

class Users extends Model implements \PayingUserInterface {
    public $_table = 'tblUsers';
    public $_key = 'user_id';
    public $_Entity = \model\Entity\UsersEntity::class;

    public static function byMobile(?string $mobile) {
        return self::getOneFiltered('user_mobile', $mobile);
    }

    public static function findToken(?string $get_header): ?UsersEntity {
        return self::byToken($get_header);
    }

    public static function byToken(string $token): ?UsersEntity {
        return self::getOneFiltered('token', $token);
    }

    public function UserMobile(int $user_id): string {
        return 'user_mobile';
    }
}
