<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class Announcements extends View
{

    public $SingularName = 'اطلاعیه';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('متن اطلاعیه'),
                                                                    HtmlTags::Th('وضعیت اطلاعیه'),
                                                                    HtmlTags::Th('وضعیت اطلاعیه'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'announcement_text',
                                                                    'announcement_status'=>function($item){
                                                                    return $item==1?"ثابت":"موقت";
                                                                },'announcement_active'=>function($item){
                                                                       if ($item==1){
                                                                           return HtmlTags::Span('.badge.badge-pill.badge-success.p-2')->Content(
                                                                               "اطلاعیه فعال"
                                                                           );
                                                                       }else{
                                                                           return HtmlTags::Span('.badge.badge-pill.badge-danger.p-2')->Content(
                                                                               "اطلاعیه غیر فعال"
                                                                           );
                                                                       }
                                                                    }
                                                                ],true,true,false,false,function ($row){
                                                                    if ($row->announcement_active == '1'){
                                                                        return HtmlTags::Button('.btn.btn-outline-danger.p-2.m-2.deActiveAnnouncement')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times())
                                                                        )->Data_('id', $row->announcement_id)->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('غیر فعال سازی اطلاعیه');
                                                                    }else{
                                                                        return HtmlTags::Button('.btn.btn-outline-success.p-2.m-2.activeAnnouncement')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
                                                                        )->Data_('id', $row->announcement_id)->Data_('toggle', 'tooltip')
                                                                            ->Data_('placement', 'top')
                                                                            ->Title('فعال سازی اطلاعیه');
                                                                    }
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        $status = HtmlTags::Option()->Selected()->Disabled()->Content('لطفا یک مورد را انتخاب کنید') .
            HtmlTags::Option()->Value(1)->Content('ثابت') .
            HtmlTags::Option()->Value(2)->Content('موقت');
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .
                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('وضعیت اطلاعیه') .
                                        $this->Html()->Select('announcement_status', 'announcement_status', $status) .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('تصویر اطلاعیه') .
                                        $this->Html()->ImageInput('announcement_image') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('متن اطلاعیه') .
                                        $this->Html()->TextArea('announcement_text') .
                                        $this->Html()->FormGroupEnd() .


                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        