<?php

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use View;

class AppVersion extends View {

    public $SingularName = 'نسخه ی اپ';
    public $PluralName = 'نسخه ی اپ';

    public function main(Document &$document) {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('نسخه ی کنونی'), HtmlTags::Th('آیا نسخه ی آپدیت اجباری است؟'), HtmlTags::Th('لینک مستقیم'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'app_version_current',
                                                                    'app_version_is_forced_yes_no',
                                                                    'app_version_direct_link',
                                                                ])
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form() {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .
                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('نسخه ی کنونی') .
                                        $this->Html()->Input('app_version_current') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(6) .
                                        $this->Html()->Label('آیا نسخه ی آپدیت اجباری است؟') .
                                        $this->Html()->Input('app_version_is_forced_yes_no') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(8) .
                                        $this->Html()->Label('لینک مستقیم') .
                                        $this->Html()->Url('app_version_direct_link') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('لینک مستقیم موجود است؟') .
                                        $this->Html()->Input('app_version_direct_link_yes_no') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(8) .
                                        $this->Html()->Label('لینک گوگل پلی') .
                                        $this->Html()->Url('app_version_google_play_link') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('لینک گوگل پلی موجود است؟') .
                                        $this->Html()->Input('app_version_google_play_link_yes_no') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(8) .
                                        $this->Html()->Label('لینک IApps') .
                                        $this->Html()->Url('app_version_iapps_link') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(4) .
                                        $this->Html()->Label('لینک iApps موجود است؟') .
                                        $this->Html()->Input('app_version_iapps_yes_no') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document) {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document) {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document) {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document) {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}