<?

namespace view;

use DOMWrap\Document;
use FwHtml\Elements\Tags\Main\HtmlTags;
use FwHtml\FontAwesome;
use View;

class AppVideos extends View
{

    public $SingularName = 'ویدیو آموزشی';
    public $PluralName = 'ویدیو های آموزشی';

    public function main(Document &$document)
    {
        $document->html = $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndAdd()
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                HtmlTags::Table('.table.table-bordered.table-striped')
                                                    ->Content(
                                                        HtmlTags::Thead('.table-dark')
                                                            ->Content(
                                                                HtmlTags::Tr()->Content(
                                                                    HtmlTags::Th('ردیف')->Width('50'),
                                                                    HtmlTags::Th('ویدیو'),
                                                                    HtmlTags::Th('وضعیت'),
                                                                    HtmlTags::Th('.no-sort عملیات')->Width('150')
                                                                )
                                                            ),
                                                        HtmlTags::Tbody()
                                                            ->Content(
                                                                $this->show([
                                                                    'video' => function ($item) {
                                                                        $src = 'https://' . __HOST__ . '/src/images/AppVideos/' . $item;
                                                                        return "<video width='320' height='240' controls>
                                                                               <source src='$src' type='video/mp4'>
                                                                               </video>";
                                                                    },
                                                                    'video_status' => function ($item) {
                                                                        if ($item == 1) {
//                                                                        return"<h4><span class='badge badge-pill badge-success mt-5'>ویدیو فعال</span></h4>";
                                                                            return HtmlTags::Span('.badge.badge-pill.badge-success.p-2')->Content(
                                                                                "ویدیو فعال"
                                                                            );
                                                                        } else {
//                                                                        return "<h4><span class='badge badge-pill badge-danger mt-5'>ویدیو غیر فعال</span></h4>";
                                                                            return HtmlTags::Span('.badge.badge-pill.badge-danger.p-2')->Content(
                                                                                "ویدیو غیر فعال"
                                                                            );
                                                                        }
                                                                    }
                                                                ], true, true, false, false, function ($row) {
                                                                    if ($row->video_status == '1') {
                                                                        return HtmlTags::Button('.btn.btn-outline-danger.m-2.p-2.deActiveVideo')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Times())
                                                                                ->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('غیر فعال سازی ویدیو'),
                                                                        )->Data_('id', $row->video_id);
                                                                    } else {
                                                                        return HtmlTags::Button('.btn.btn-outline-success.m-2.p-2.activeVideo')->Content(
                                                                            HtmlTags::I(".m-0.p-1")->Class(FontAwesome::Check())
                                                                                ->Data_('toggle', 'tooltip')
                                                                                ->Data_('placement', 'top')
                                                                                ->Title('فعال سازی ویدیو'),
                                                                        )->Data_('id', $row->video_id);
                                                                    }
                                                                })
                                                            )
                                                    )
                                            )
                                    )
                            )
                        )
                );
    }

    public function Form()
    {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .

                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('ویدیو') .
                                        HtmlTags::Input(".form-control#video")->Name('video')->Type('file')->Accept('video/*') .
                                        $this->Html()->FormGroupEnd() .

                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }

    public function addIndex(Document &$document)
    {
        $document->html = $this->Form();
    }

    public function editIndex(Document &$document)
    {
        $this->doFill();
        $document->html = $this->Form();
    }

    public function deleteIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

    public function viewIndex(Document &$document)
    {
        $this->doFill();
        $this->doDisableAll();
        $document->html = $this->Form();
    }

}
        