
$(function () {
    $.checkCheckBox()
    $(".file-checkbox").on('ifChecked', function () {
        $("#deleteButton").attr('disabled', false)
    })
    $(".file-checkbox").on('ifUnchecked', function () {
        if ($(".file-checkbox:checked").length === 0) {
            $("#deleteButton").attr('disabled', true)
        }
    });
    $(".copyLink").on('click', function () {
        console.log($(this).data('link'))
        navigator.clipboard.writeText($(this).data('link'));

    })
    $("#addFolder").on('click', function () {
        let id = $(this).data('folder') ?? 0;
        Swal.fire({
            icon: "success",
            title: "افزودن پوشه",
            text: "لطفا نام پوشه را مشخص کنید",
            showConfirmButton: true,
            showCancelButton: true,
            confirmButtonText: 'تایید',
            input: 'text',
            inputAttributes: {
                placeholder: "نام پوشه",
            },
            cancelButtonText: 'انصراف',
            confirmButtonColor: '#00aa21',
            reverseButtons: true,
            cancelButtonColor: 'rgba(199,0,8,0.88)',
            preConfirm: (text) => {
                if (text.toString() === '') {
                    Swal.showValidationMessage(
                        `لطفا نام پوشه را وارد کنید`
                    )
                    return;
                }
                $.loader();
                $.ajax({
                    url: "controllers/BaseTables/Files/Files",
                    type: "POST",
                    data: {
                        controller_type: "addFolder",
                        name: text,
                        parentId: id,
                    },
                    success: res => {
                        if (res === "1"){
                            $.loader();
                            $("#fw_refresh_btn").click()
                        }else {
                            Swal.fire({
                                icon: "error",
                                title: "خطا",
                                text:'افزودن پوشه با خطا مواجه شد، لطفا دوباره تلاش کنید',
                                confirmButtonText: "فهمیدم"
                            })
                        }
                    }
                })
            },
        })
    })
    $("#deleteButton").on('click', function () {
        let output = [];
        $(".file-checkbox:checked").each(function () {
            output.push($(this).val())
        })
        $.ajax({
            url: "controllers/BaseTables/Files/Files",
            type: "POST",
            data: {
                controller_type: "deleteFile",
                ids: JSON.stringify(output),
            },
            success: res => {
                $("#fw_refresh_btn").click()
            }
        })
    })
    $(".deleteFolder").on('click', function () {
        let id = $(this).data('id');
        Swal.fire({
            icon:'error',
            title : "حذف پوشه",
            text:'آیا از حذف پوشه مورد نظر اطمینان دارید ؟',
            showConfirmButton: true,
            showCancelButton: true,
            confirmButtonText:"حذف",
            cancelButtonText: "انصراف",
            confirmButtonColor: 'rgba(199,0,8,0.88)',
            preConfirm: () => {

                $.ajax({
                    url: "controllers/BaseTables/Files/Files",
                    type: "POST",
                    data: {
                        controller_type: "deleteFolder",
                        id: id,
                    },
                    success: res => {
                        if (res==='1'){
                            window.location.href = "http://medflash.ir/admin/Files";
                        }else {
                            Swal.fire({
                                icon:'error',
                                title:"خطا",
                                text:'حذف پوشه با خطا مواجه شد',
                                confirmButtonText:"فهمیدم"
                            })
                        }
                    }
                })
            },
        })


    })
})
