<?

namespace view;

use View;
use DOMWrap\Document;
use FwHtml\FontAwesome;
use model\Entity\FoldersEntity;
use FwHtml\Elements\Tags\Main\HtmlTags;

class Files extends View {
	
	public $SingularName = 'فایل';
	
	public function main(Document &$document) {
		$document->html = $this->filesMain();
	}
	
	public function filesMain() {
		return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                (isset($_GET['folderId']) ? $this->Html()->backBtn() : ""),
                                                $this->Html()->refresh(),
                                                $this->Html()->addBtn('', ['folderId' => $_GET['folderId']]),
                                                HtmlTags::Button('.btn.btn-danger.pull-left.m-2#deleteButton')->Content(
                                                    HtmlTags::I('.ml-2')->Class(FontAwesome::Trash_o()),
                                                    "حذف"
                                                )->Attrs(['disabled' => true]),
                                                HtmlTags::Button('.btn.btn-warning.pull-left.m-2#addFolder')->Content(
                                                    HtmlTags::I('.ml-2')->Class(FontAwesome::Folder_open_o()),
                                                    "افزودن پوشه"
                                                )->Data_('folder', $_GET['folderId'])
                                            ),
                                        HtmlTags::Div('.card-body.d-flex.flex-wrap')
                                            ->Content(
                                                $this->files()
                                            )
                                    )
                            )
                        )
                );
	}
	
	private function files() {
		return HtmlTags::Div('.file-manager-container.file-manager-col-view')->Content(
			$this->getData()->map(function ($file) {
				return $this->buildFile($file);
			})->values()->join('')
		);
	}
	
	private function buildFile($file) {
		$isFolder = $file instanceof FoldersEntity;
		return HtmlTags::Div(".file-item" . ($isFolder ? ".ajax" : '.copyLink'))->Data_('link', !$isFolder ? $file->path() : '')->Attrs(['rel' => (new \controller\Files())->RelPath(['folderId' => $file->id()])])->Content(
			HtmlTags::Div('.file-item-select-bg.bg-primary'),
			HtmlTags::Div('.file-item-checkbox')->Content(
				!$isFolder ? HtmlTags::Input('.form-control.file-checkbox')->Type('checkbox')->Value($file->id()) :
					HtmlTags::Button('.btn.btn-danger.p-1.deleteFolder')->Content(HtmlTags::I()->Class(FontAwesome::Trash_o()))->Data_('id',$file->id())->Type("button")
			),
			HtmlTags::Div('.file-item-img')->Content(
				$file->thumb()
			),
			HtmlTags::A('.file-item-name')->Href('javascript:void(0)')->Content(
				$file->name()
			)
		);
	}
	
	public function addIndex(Document &$document) {
		$document->html = $this->Form();
	}


    public function Form() {
        return $this->Html()->BreadCrumbs() . HtmlTags::Section('.content')
                ->Content(
                    HtmlTags::Div('.row')
                        ->Content(
                            HtmlTags::Div('.col-md-12')->Content(
                                HtmlTags::Div('.card.card-primary.card-outline')
                                    ->Content(
                                        HtmlTags::Div('.card-header')
                                            ->Content(
                                                $this->Html()->CardTitle(),
                                                $this->Html()->refreshAndBack()
                                            ),
                                        $this->Html()->FormStart() .
                                        hiddenInput($_GET['folderId'],'folder_id'),
                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('فایل') .
                                        $this->Html()->ImgInput('file_path') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->FormGroupStart(12) .
                                        $this->Html()->Label('جایگزین متنی') .
                                        $this->Html()->Input('file_alt') .
                                        $this->Html()->FormGroupEnd() .
                                        $this->Html()->CardFooter()
                                    )
                            )
                        )
                );
    }
	public function editIndex(Document &$document) {
		$this->doFill();
		$document->html = $this->Form();
	}
	
	public function deleteIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
	public function viewIndex(Document &$document) {
		$this->doFill();
		$this->doDisableAll();
		$document->html = $this->Form();
	}
	
}
