$(function (){

    var editor = new FroalaEditor('#blog_desc', {
        events: {
            "image.beforeUpload": function (files) {
                let editor = this;
                if (files.length) {
                    // Create a File Reader.
                    var reader = new FileReader();
                    // Set the reader to insert images when they are loaded.
                    reader.onload = function (e) {
                        let result = e.target.result;
                        editor.image.insert(result, null, null, editor.image.get());
                    };
                    // Read image as base64.
                    reader.readAsDataURL(files[0]);
                }
                // Stop default upload chain.
                return false;
            }
        },
    }, function () {
        // Call the method inside the initialized event.
        let html = $('#blog_desc').get(0).innerText;
        // editor.html.set(html);
    })

})