$(function () {
    $("#unArchiveChat").hide();
    $("#chatOperatorId").on('change', function () {
        $(".chat-operator").hide();
        let id = $(this).val();
        if (id === 'all') {
            $(`.chat-operator`).show();
        } else {
            $(`#chat_operator_${id}`).show();
        }
    });
    $("#chatSearch").on('input', function () {
        let val = $(this).val();
        $(".chat-contact").each(function () {
            let text = $(this).find('.contacts-list-name').text();
            console.log(text)
            if (text.toString().includes(val)) {
                $(this).parents('li').show()
            } else {
                $(this).parents('li').hide()
            }
        })
    })
    $("#unArchiveChat").on('click', function () {
        let id = $("#chatId").val();

        $.loader();
        $.ajax({
                url: "controllers/Chat/Chats/Chats",
                data: {
                    controller_type: "unArchiveChat",
                    chatId: id,
                },
                type: "POST",
                success: res => {
                    $.loader();
                    GoToUrl('Chat/Chats/Chats');
                },
            }
        );
    });
    $(".chat-contact").on('click', function () {
        let id = $(this).data('id');
        $.loader();
        $.ajax({
            url: "controllers/Chat/Chats/Chats",
            data: {
                controller_type: "fetchArchive",
                chatId: id,
            },
            type: "POST",
            success: res => {
                $.loader();
                try {
                    let parsed = JSON.parse(res);
                    $("#chat_content").html(parsed.content);
                    $("[data-toggle=tooltip]").tooltip();
                    $("#chatId").val(id)
                    $("#cardTitle").text(`چت - شماره پرونده: ${parsed.orderId}`)
                    if (parsed.isClosed === true) {
                        $("#card_footer").hide();
                        $("#card_footer_2").show();
                        $("#unArchiveChat").show();
                    } else {
                        $("#card_footer").show()
                        $("#card_footer_2").hide();
                        $("#unArchiveChat").hide()
                        $('#chat_content').scrollTop($('#chat_content')[0].scrollHeight);

                    }
                } catch (e) {
                    console.log(e)
                }
            }
        });
    });


})