$(function () {
    let oldInterval = 0;
    let oldCount = 0;
    $("#archiveChat").hide();
    $("#chatOperatorId").on('change', function () {
        $(".chat-operator").hide();
        let id = $(this).val();
        if (id === 'all') {
            $(`.chat-operator`).show();
        } else {
            $(`#chat_operator_${id}`).show();
        }
    });
    $("#chatSearch").on('input', function () {
        let val = $(this).val();
        $(".chat-contact").each(function () {
            let text = $(this).find('.contacts-list-name > .contact-list-name-inner').text(),
                number = $(this).find('.contacts-list-name > .contact-list-name-inner').data('number');
            if (text.toString().includes(val) || number.toString().includes(val)) {
                $(this).parents('li:not(.chat-operator)').removeClass('d-none')
            } else {
                $(this).parents('li:not(.chat-operator)').addClass('d-none')
            }
        })
        $(".chat-operator").each(function () {
            let ul = $(this).find('.contacts-list');
            let visibleLiCount = $(ul).find('li:not(.d-none)').length;
            if (visibleLiCount === 0) {
                $(this).hide();
            } else {
                $(this).show();
            }
        })
    })
    $("#archiveChat").on('click', function () {
        let id = $("#chatId").val();
        $.loader();
        $.ajax({
                url: "controllers/Chat/Chats/Chats",
                data: {
                    controller_type: "archiveChat",
                    chatId: id,
                },
                type: "POST",
                success: res => {
                    $.loader();
                    GoToUrl('^archivedChats^Chat/Chats/Chats');
                },
            }
        );
    });
    $(".chat-contact").on('click', function () {
        Intervals.clear(oldInterval);

        let id = $(this).data('id');
        $.loader();
        $.ajax({
            url: "controllers/Chat/Chats/Chats",
            data: {
                controller_type: "fetchMessages",
                chatId: id,
            },
            type: "POST",
            success: res => {
                $.loader();
                try {
                    let parsed = JSON.parse(res);
                    $("#chat_content").html(parsed.content);
                    $("[data-toggle=tooltip]").tooltip();
                    $(`.chat-contact[data-id=${id}]`).find('.contacts-list-count').text('0'.toFa());
                    $("#cardTitle").text(`چت - شماره پرونده: ${parsed.orderId} - ${parsed.service} برای ${parsed.user}`)
                    if (parsed.isClosed === true) {
                        $("#card_footer").hide();
                        $("#card_footer_2").show();
                        $("#archiveChat").show();
                    } else {
                        $("#card_footer").show()
                        $("#card_footer_2").hide();
                        $("#archiveChat").hide()
                        $('#chat_content').scrollTop($('#chat_content')[0].scrollHeight);

                    }
                    var imgs = document.images,
                        len = imgs.length,
                        counter = 0;

                    [].forEach.call(imgs, function (img) {
                        if (img.complete)
                            incrementCounter();
                        else
                            img.addEventListener('load', incrementCounter, false);
                    });

                    function incrementCounter() {
                        counter++;
                        if (counter === len) {
                            $('#chat_content').scrollTop($('#chat_content')[0].scrollHeight);
                        }
                    }

                    oldCount = parsed.count;
                    $("#chatId").val(id);

                    let dropzoneControl = $("#chat_content")[0].dropzone;
                    if (dropzoneControl) {
                        dropzoneControl.destroy();
                    }
                    $("#chat_content").on('dragover', function () {
                        $(this).addClass('my-dragover');
                    });
                    $("#chat_content").on('dragleave', function () {
                        $(this).removeClass('my-dragover');
                    });
                    $("#chat_content").on('drop', function () {
                        $(this).removeClass('my-dragover');
                    });
                    $("#chat_content").dropzone({
                        url: `/admin/uploadChatFile/${id}`,
                        addRemoveLinks: true,
                        init: function () {
                            const _this = this;
                            this.on('drop', function () {
                                $.loader();
                            })
                            this.on("complete", function (file) {
                                $.loader();
                            });
                        },
                    });
                    oldInterval = setInterval(() => {
                        $.ajax({
                            url: "controllers/Chat/Chats/Chats",
                            data: {
                                controller_type: "fetchMessages",
                                chatId: id,
                            },
                            type: "POST",
                            success: res => {
                                try {
                                    let parsed = JSON.parse(res);
                                    if (parsed.count !== oldCount) {
                                        $("#chat_content").html(parsed.content);
                                        $("[data-toggle=tooltip]").tooltip();

                                        oldCount = parsed.count;
                                        $("#chat_content").css("overflow", "scroll");
                                        $('#chat_content').scrollTop($('#chat_content')[0].scrollHeight);
                                    }
                                    if (parsed.isClosed === true) {
                                        $("#card_footer").hide();
                                        $("#card_footer_2").show();
                                        $("#archiveChat").show()
                                    } else {
                                        $("#closedChatAlert").remove();
                                        $("#card_footer_2").hide();
                                        $("#card_footer").show();
                                        $("#archiveChat").hide()
                                    }
                                } catch (e) {
                                }
                            },
                        });
                    }, 1500);
                    Intervals.add(oldInterval);
                } catch (e) {
                    console.log(e)
                }
            }
        });
    });
    $("#upload-btn").on('change', function () {
        let chatId = $("#chatId").val();
        console.log(this.files[0])
        const formData = new FormData();
        formData.append('file', this.files[0])
        $.ajax({
            url: `/admin/uploadChatFile/${chatId}`,
            data: formData,
            type: "POST",
            processData: false,
            cache: false,
            contentType: false,
            success: res => {
                console.log(res)
            }
        })
    })
    $("#message_form").submit(function (e) {
        e.preventDefault();
        let formData = new FormData(this);
        formData.append('controller_type', 'sendMessage');
        $.loader();
        $.ajax({
            url: "controllers/Chat/Chats/Chats",
            cache: false,
            contentType: false,
            processData: false,
            data: formData,
            type: "POST",
            success: res => {
                $.loader();
                try {
                    let parsed = JSON.parse(res);
                    $("#chat_content").html(parsed.content);
                    $("#card_footer").show();
                    $("#card_footer_2").hide();
                    $('#chat_content').scrollTop($('#chat_content')[0].scrollHeight);
                    $("#message_content").val('')
                } catch (e) {
                    console.log(e)
                }
            }
        });
    })

    $(".closeChat").on('click', function () {
        let chatId = $("#chatId").val();
        Swal.fire({
            icon: 'info',
            title: 'پایان چت',
            text: "آیا از بستن چت مورد نظر مطمئن هستید؟",
            confirmButtonColor: "green",
            cancelButtonColor: "red",
            confirmButtonText: "بله",
            cancelButtonText: "انصراف",
            reverseButtons: true,
            showCancelButton: true,
            preConfirm: res => {
                $.loader();
                $.ajax({
                    url: "controllers/Chat/Chats/Chats",
                    data: {
                        controller_type: 'closeChat',
                        chatId: chatId,
                    },
                    type: "POST",
                    success: res => {
                        $.loader();
                        $("#card_footer").hide();
                        $("#card_footer_2").show();
                    }
                });
            }
        })
    });
    $(".closeOrder").on('click', function () {
        let chatId = $("#chatId").val();
        Swal.fire({
            icon: 'info',
            title: 'اتمام کار',
            text: "آیا از اتمام این پرونده مطمئن هستید؟",
            confirmButtonColor: "green",
            cancelButtonColor: "red",
            confirmButtonText: "بله",
            cancelButtonText: "انصراف",
            reverseButtons: true,
            showCancelButton: true,
            preConfirm: res => {
                $.loader();
                $.ajax({
                    url: "controllers/Chat/Chats/Chats",
                    data: {
                        controller_type: 'closeOrder',
                        chatId: chatId,
                    },
                    type: "POST",
                    success: res => {
                        $.loader();
                        GoToUrl('^archivedChats^Chat/Chats/Chats');
                    }
                });
            }
        })
    });
    $("#openChat").on('click', function () {
        let chatId = $("#chatId").val();
        if (chatId > 0) {
            Swal.fire({
                icon: 'info',
                title: 'باز کردن مجدد چت',
                text: "آیا از باز کردن مجدد چت مورد نظر مطمئن هستید؟",
                confirmButtonColor: "green",
                cancelButtonColor: "red",
                confirmButtonText: "بله",
                cancelButtonText: "انصراف",
                reverseButtons: true,
                showCancelButton: true,
                preConfirm: res => {
                    $.loader();
                    $.ajax({
                        url: "controllers/Chat/Chats/Chats",
                        data: {
                            controller_type: 'openChat',
                            chatId: chatId,
                        },
                        type: "POST",
                        success: res => {
                            $.loader();

                        }
                    });
                }
            })
        }
    });

    $("#attachment").on('click', function () {
        $.loader();
        $.ajax({
            url: "controllers/Chat/Chats/Chats",
            type: "POST",
            data: {
                controller_type: 'fetchChatNewFactor',
                chatId: $("#chatId").val(),
            },
            success: res => {
                $.loader();
                $("#price_0").val(number_format(res.price));
                // $("#discount_1").val('9');
                $("#price_1").val(res.discount);
                $("#attachmentModal").modal('show');
            }
        })
    });
    $("#addRow").on('click', function () {
        let trContent = $("#factorBody").find('tr:first-child');
        let tr = $("#factorBody").find('tr:last-child');
        let id = $(tr).data('id');
        id = parseInt(id) + 1;
        $("#factorBody").append(
            `<tr data-id="${id}">
                ${$(trContent).html().replaceAll('_0', `_${id}`).replaceAll("انجام خدمات", "")}
            </tr>`
        )

        $("#factorBody tr:last-child td:first-child").text(id.toString())
        $(`#price_${id}`).checkPrice();
        $(`#discount_${id}`).checkNumber();
    });
    $(".removeRow").on('click', function () {
        $(this).parents('tr').remove()
    })
    $("#factorForm").submit(function (e) {
        e.preventDefault();
        let formData = new FormData(this);
        formData.append('controller_type', 'sendFactor');
        formData.append('chatId', $("#chatId").val());
        $.loader();
        $.ajax({
            url: "controllers/Chat/Chats/Chats",
            cache: false,
            contentType: false,
            processData: false,
            data: formData,
            type: "POST",
            success: res => {
                $.loader();
                $("#attachmentModal").modal('hide');
            }
        });
    })


    // RECORDER
})